// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Conversations.Models
{
    [PersistableModelProxy(typeof(UnknownResolutionBase))]
    public partial class ResolutionBase : IUtf8JsonSerializable, IJsonModel<ResolutionBase>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResolutionBase>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResolutionBase>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResolutionBase>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResolutionBase)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("resolutionKind"u8);
            writer.WriteStringValue(ResolutionKind.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResolutionBase IJsonModel<ResolutionBase>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResolutionBase>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResolutionBase)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResolutionBase(document.RootElement, options);
        }

        internal static ResolutionBase DeserializeResolutionBase(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("resolutionKind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AgeResolution": return AgeResolution.DeserializeAgeResolution(element, options);
                    case "AreaResolution": return AreaResolution.DeserializeAreaResolution(element, options);
                    case "BooleanResolution": return BooleanResolution.DeserializeBooleanResolution(element, options);
                    case "CurrencyResolution": return CurrencyResolution.DeserializeCurrencyResolution(element, options);
                    case "DateTimeResolution": return DateTimeResolution.DeserializeDateTimeResolution(element, options);
                    case "InformationResolution": return InformationResolution.DeserializeInformationResolution(element, options);
                    case "LengthResolution": return LengthResolution.DeserializeLengthResolution(element, options);
                    case "NumberResolution": return NumberResolution.DeserializeNumberResolution(element, options);
                    case "NumericRangeResolution": return NumericRangeResolution.DeserializeNumericRangeResolution(element, options);
                    case "OrdinalResolution": return OrdinalResolution.DeserializeOrdinalResolution(element, options);
                    case "SpeedResolution": return SpeedResolution.DeserializeSpeedResolution(element, options);
                    case "TemperatureResolution": return TemperatureResolution.DeserializeTemperatureResolution(element, options);
                    case "TemporalSpanResolution": return TemporalSpanResolution.DeserializeTemporalSpanResolution(element, options);
                    case "VolumeResolution": return VolumeResolution.DeserializeVolumeResolution(element, options);
                    case "WeightResolution": return WeightResolution.DeserializeWeightResolution(element, options);
                }
            }
            return UnknownResolutionBase.DeserializeUnknownResolutionBase(element, options);
        }

        BinaryData IPersistableModel<ResolutionBase>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResolutionBase>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResolutionBase)} does not support writing '{options.Format}' format.");
            }
        }

        ResolutionBase IPersistableModel<ResolutionBase>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResolutionBase>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResolutionBase(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResolutionBase)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResolutionBase>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ResolutionBase FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeResolutionBase(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
