// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The regex key extra data kind. </summary>
    public partial class RegexKey : ConversationEntityExtraInformation
    {
        /// <summary> Initializes a new instance of <see cref="RegexKey"/>. </summary>
        internal RegexKey()
        {
            ExtraInformationKind = ExtraInformationKind.RegexKey;
        }

        /// <summary> Initializes a new instance of <see cref="RegexKey"/>. </summary>
        /// <param name="extraInformationKind"> The extra information object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="key"> The key of the regex pattern used in extracting the entity. </param>
        /// <param name="regexPattern"> The .NET regex pattern used in extracting the entity. Please visit https://docs.microsoft.com/dotnet/standard/base-types/regular-expressions for more information about .NET regular expressions. </param>
        internal RegexKey(ExtraInformationKind extraInformationKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string key, string regexPattern) : base(extraInformationKind, serializedAdditionalRawData)
        {
            Key = key;
            RegexPattern = regexPattern;
        }

        /// <summary> The key of the regex pattern used in extracting the entity. </summary>
        public string Key { get; }
        /// <summary> The .NET regex pattern used in extracting the entity. Please visit https://docs.microsoft.com/dotnet/standard/base-types/regular-expressions for more information about .NET regular expressions. </summary>
        public string RegexPattern { get; }
    }
}
