// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> represents the resolution of numeric intervals. </summary>
    public partial class NumericRangeResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="NumericRangeResolution"/>. </summary>
        /// <param name="rangeKind"> The kind of range that the resolution object represents. </param>
        /// <param name="minimum"> The beginning value of  the interval. </param>
        /// <param name="maximum"> The ending value of the interval. </param>
        internal NumericRangeResolution(RangeKind rangeKind, double minimum, double maximum)
        {
            ResolutionKind = ResolutionKind.NumericRangeResolution;
            RangeKind = rangeKind;
            Minimum = minimum;
            Maximum = maximum;
        }

        /// <summary> Initializes a new instance of <see cref="NumericRangeResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="rangeKind"> The kind of range that the resolution object represents. </param>
        /// <param name="minimum"> The beginning value of  the interval. </param>
        /// <param name="maximum"> The ending value of the interval. </param>
        internal NumericRangeResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, RangeKind rangeKind, double minimum, double maximum) : base(resolutionKind, serializedAdditionalRawData)
        {
            RangeKind = rangeKind;
            Minimum = minimum;
            Maximum = maximum;
        }

        /// <summary> Initializes a new instance of <see cref="NumericRangeResolution"/> for deserialization. </summary>
        internal NumericRangeResolution()
        {
        }

        /// <summary> The kind of range that the resolution object represents. </summary>
        public RangeKind RangeKind { get; }
        /// <summary> The beginning value of  the interval. </summary>
        public double Minimum { get; }
        /// <summary> The ending value of the interval. </summary>
        public double Maximum { get; }
    }
}
