// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> A resolution for numeric entity instances. </summary>
    public partial class NumberResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="NumberResolution"/>. </summary>
        /// <param name="numberKind"> The type of the extracted number entity. </param>
        /// <param name="value"> A numeric representation of what the extracted text denotes. </param>
        internal NumberResolution(NumberKind numberKind, double value)
        {
            ResolutionKind = ResolutionKind.NumberResolution;
            NumberKind = numberKind;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="NumberResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="numberKind"> The type of the extracted number entity. </param>
        /// <param name="value"> A numeric representation of what the extracted text denotes. </param>
        internal NumberResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, NumberKind numberKind, double value) : base(resolutionKind, serializedAdditionalRawData)
        {
            NumberKind = numberKind;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="NumberResolution"/> for deserialization. </summary>
        internal NumberResolution()
        {
        }

        /// <summary> The type of the extracted number entity. </summary>
        public NumberKind NumberKind { get; }
        /// <summary> A numeric representation of what the extracted text denotes. </summary>
        public double Value { get; }
    }
}
