// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Multi Language Conversation Analysis Input. </summary>
    public partial class MultiLanguageConversationInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MultiLanguageConversationInput"/>. </summary>
        /// <param name="conversations">
        /// Array of conversation items
        /// Please note <see cref="ConversationInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="TextConversation"/> and <see cref="TranscriptConversation"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversations"/> is null. </exception>
        public MultiLanguageConversationInput(IEnumerable<ConversationInput> conversations)
        {
            Argument.AssertNotNull(conversations, nameof(conversations));

            Conversations = conversations.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="MultiLanguageConversationInput"/>. </summary>
        /// <param name="conversations">
        /// Array of conversation items
        /// Please note <see cref="ConversationInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="TextConversation"/> and <see cref="TranscriptConversation"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MultiLanguageConversationInput(IList<ConversationInput> conversations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Conversations = conversations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MultiLanguageConversationInput"/> for deserialization. </summary>
        internal MultiLanguageConversationInput()
        {
        }

        /// <summary>
        /// Array of conversation items
        /// Please note <see cref="ConversationInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="TextConversation"/> and <see cref="TranscriptConversation"/>.
        /// </summary>
        public IList<ConversationInput> Conversations { get; }
    }
}
