// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Context object with previous QnA's information. </summary>
    public partial class KnowledgeBaseAnswerContext
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KnowledgeBaseAnswerContext"/>. </summary>
        /// <param name="previousQnaId"> Previous turn top answer result QnA ID. </param>
        public KnowledgeBaseAnswerContext(int previousQnaId)
        {
            PreviousQnaId = previousQnaId;
        }

        /// <summary> Initializes a new instance of <see cref="KnowledgeBaseAnswerContext"/>. </summary>
        /// <param name="previousQnaId"> Previous turn top answer result QnA ID. </param>
        /// <param name="previousQuestion"> Previous user query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KnowledgeBaseAnswerContext(int previousQnaId, string previousQuestion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PreviousQnaId = previousQnaId;
            PreviousQuestion = previousQuestion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KnowledgeBaseAnswerContext"/> for deserialization. </summary>
        internal KnowledgeBaseAnswerContext()
        {
        }

        /// <summary> Previous turn top answer result QnA ID. </summary>
        public int PreviousQnaId { get; }
        /// <summary> Previous user query. </summary>
        public string PreviousQuestion { get; set; }
    }
}
