// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Context of the summary with a conversation item ID. </summary>
    public partial class ItemizedSummaryContext
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ItemizedSummaryContext"/>. </summary>
        /// <param name="offset"> Start position for the context. Use of different 'stringIndexType' values can affect the offset returned. </param>
        /// <param name="length"> The length of the context. Use of different 'stringIndexType' values can affect the length returned. </param>
        /// <param name="conversationItemId"> Reference to the ID of ConversationItem. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversationItemId"/> is null. </exception>
        internal ItemizedSummaryContext(int offset, int length, string conversationItemId)
        {
            Argument.AssertNotNull(conversationItemId, nameof(conversationItemId));

            Offset = offset;
            Length = length;
            ConversationItemId = conversationItemId;
        }

        /// <summary> Initializes a new instance of <see cref="ItemizedSummaryContext"/>. </summary>
        /// <param name="offset"> Start position for the context. Use of different 'stringIndexType' values can affect the offset returned. </param>
        /// <param name="length"> The length of the context. Use of different 'stringIndexType' values can affect the length returned. </param>
        /// <param name="conversationItemId"> Reference to the ID of ConversationItem. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ItemizedSummaryContext(int offset, int length, string conversationItemId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Offset = offset;
            Length = length;
            ConversationItemId = conversationItemId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ItemizedSummaryContext"/> for deserialization. </summary>
        internal ItemizedSummaryContext()
        {
        }

        /// <summary> Start position for the context. Use of different 'stringIndexType' values can affect the offset returned. </summary>
        public int Offset { get; }
        /// <summary> The length of the context. Use of different 'stringIndexType' values can affect the length returned. </summary>
        public int Length { get; }
        /// <summary> Reference to the ID of ConversationItem. </summary>
        public string ConversationItemId { get; }
    }
}
