// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents the information (data) entity resolution model. </summary>
    public partial class InformationResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="InformationResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The information (data) Unit of measurement. </param>
        internal InformationResolution(double value, InformationUnit unit)
        {
            ResolutionKind = ResolutionKind.InformationResolution;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="InformationResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The information (data) Unit of measurement. </param>
        internal InformationResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, double value, InformationUnit unit) : base(resolutionKind, serializedAdditionalRawData)
        {
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="InformationResolution"/> for deserialization. </summary>
        internal InformationResolution()
        {
        }

        /// <summary> The numeric value that the extracted text denotes. </summary>
        public double Value { get; }
        /// <summary> The information (data) Unit of measurement. </summary>
        public InformationUnit Unit { get; }
    }
}
