// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The Datetime SubKind. </summary>
    public readonly partial struct DateTimeSubKind : IEquatable<DateTimeSubKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DateTimeSubKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DateTimeSubKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TimeValue = "Time";
        private const string DateValue = "Date";
        private const string DateTimeValue = "DateTime";
        private const string DurationValue = "Duration";
        private const string SetValue = "Set";

        /// <summary> Time subkind. </summary>
        public static DateTimeSubKind Time { get; } = new DateTimeSubKind(TimeValue);
        /// <summary> Date subkind. </summary>
        public static DateTimeSubKind Date { get; } = new DateTimeSubKind(DateValue);
        /// <summary> DateTime subkind. </summary>
        public static DateTimeSubKind DateTime { get; } = new DateTimeSubKind(DateTimeValue);
        /// <summary> Duration subkind. </summary>
        public static DateTimeSubKind Duration { get; } = new DateTimeSubKind(DurationValue);
        /// <summary> Set subkind. </summary>
        public static DateTimeSubKind Set { get; } = new DateTimeSubKind(SetValue);
        /// <summary> Determines if two <see cref="DateTimeSubKind"/> values are the same. </summary>
        public static bool operator ==(DateTimeSubKind left, DateTimeSubKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DateTimeSubKind"/> values are not the same. </summary>
        public static bool operator !=(DateTimeSubKind left, DateTimeSubKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DateTimeSubKind"/>. </summary>
        public static implicit operator DateTimeSubKind(string value) => new DateTimeSubKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DateTimeSubKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DateTimeSubKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
