// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> A resolution for datetime entity instances. </summary>
    public partial class DateTimeResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="DateTimeResolution"/>. </summary>
        /// <param name="timex"> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="dateTimeSubKind"> The DateTime SubKind. </param>
        /// <param name="value"> The actual time that the extracted text denote. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timex"/> or <paramref name="value"/> is null. </exception>
        internal DateTimeResolution(string timex, DateTimeSubKind dateTimeSubKind, string value)
        {
            Argument.AssertNotNull(timex, nameof(timex));
            Argument.AssertNotNull(value, nameof(value));

            ResolutionKind = ResolutionKind.DateTimeResolution;
            Timex = timex;
            DateTimeSubKind = dateTimeSubKind;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="DateTimeResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="timex"> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="dateTimeSubKind"> The DateTime SubKind. </param>
        /// <param name="value"> The actual time that the extracted text denote. </param>
        /// <param name="modifier"> An optional modifier of a date/time instance. </param>
        internal DateTimeResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string timex, DateTimeSubKind dateTimeSubKind, string value, TemporalModifier? modifier) : base(resolutionKind, serializedAdditionalRawData)
        {
            Timex = timex;
            DateTimeSubKind = dateTimeSubKind;
            Value = value;
            Modifier = modifier;
        }

        /// <summary> Initializes a new instance of <see cref="DateTimeResolution"/> for deserialization. </summary>
        internal DateTimeResolution()
        {
        }

        /// <summary> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </summary>
        public string Timex { get; }
        /// <summary> The DateTime SubKind. </summary>
        public DateTimeSubKind DateTimeSubKind { get; }
        /// <summary> The actual time that the extracted text denote. </summary>
        public string Value { get; }
        /// <summary> An optional modifier of a date/time instance. </summary>
        public TemporalModifier? Modifier { get; }
    }
}
