// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Supported parameters for a custom conversation summarization task. </summary>
    public partial class CustomConversationSummarizationActionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomConversationSummarizationActionContent"/>. </summary>
        /// <param name="projectName"> This field indicates the project name for the model. </param>
        /// <param name="deploymentName"> This field indicates the deployment name for the model. </param>
        /// <param name="summaryAspects"> Array of Summary Aspects. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="projectName"/>, <paramref name="deploymentName"/> or <paramref name="summaryAspects"/> is null. </exception>
        public CustomConversationSummarizationActionContent(string projectName, string deploymentName, IEnumerable<SummaryAspect> summaryAspects)
        {
            Argument.AssertNotNull(projectName, nameof(projectName));
            Argument.AssertNotNull(deploymentName, nameof(deploymentName));
            Argument.AssertNotNull(summaryAspects, nameof(summaryAspects));

            ProjectName = projectName;
            DeploymentName = deploymentName;
            SummaryAspects = summaryAspects.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CustomConversationSummarizationActionContent"/>. </summary>
        /// <param name="loggingOptOut"> logging opt out. </param>
        /// <param name="projectName"> This field indicates the project name for the model. </param>
        /// <param name="deploymentName"> This field indicates the deployment name for the model. </param>
        /// <param name="sentenceCount"> It controls the approximate number of sentences in the output summaries. </param>
        /// <param name="stringIndexType"> String index type. </param>
        /// <param name="summaryLength"> Controls the approximate length of the output summaries. Recommended to use summaryLength over sentenceCount. </param>
        /// <param name="summaryAspects"> Array of Summary Aspects. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomConversationSummarizationActionContent(bool? loggingOptOut, string projectName, string deploymentName, int? sentenceCount, StringIndexType? stringIndexType, SummaryLengthBucket? summaryLength, IList<SummaryAspect> summaryAspects, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoggingOptOut = loggingOptOut;
            ProjectName = projectName;
            DeploymentName = deploymentName;
            SentenceCount = sentenceCount;
            StringIndexType = stringIndexType;
            SummaryLength = summaryLength;
            SummaryAspects = summaryAspects;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomConversationSummarizationActionContent"/> for deserialization. </summary>
        internal CustomConversationSummarizationActionContent()
        {
        }

        /// <summary> logging opt out. </summary>
        public bool? LoggingOptOut { get; set; }
        /// <summary> This field indicates the project name for the model. </summary>
        public string ProjectName { get; }
        /// <summary> This field indicates the deployment name for the model. </summary>
        public string DeploymentName { get; }
        /// <summary> It controls the approximate number of sentences in the output summaries. </summary>
        public int? SentenceCount { get; set; }
        /// <summary> String index type. </summary>
        public StringIndexType? StringIndexType { get; set; }
        /// <summary> Controls the approximate length of the output summaries. Recommended to use summaryLength over sentenceCount. </summary>
        public SummaryLengthBucket? SummaryLength { get; set; }
        /// <summary> Array of Summary Aspects. </summary>
        public IList<SummaryAspect> SummaryAspects { get; }
    }
}
