// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents the currency entity resolution model. </summary>
    public partial class CurrencyResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="CurrencyResolution"/>. </summary>
        /// <param name="value"> The money amount captured in the extracted entity. </param>
        /// <param name="unit"> The unit of the amount captured in the extracted entity. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="unit"/> is null. </exception>
        internal CurrencyResolution(double value, string unit)
        {
            Argument.AssertNotNull(unit, nameof(unit));

            ResolutionKind = ResolutionKind.CurrencyResolution;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="CurrencyResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="iso4217"> The alphabetic code based on another ISO standard, ISO 3166, which lists the codes for country names. The first two letters of the ISO 4217 three-letter code are the same as the code for the country name, and, where possible, the third letter corresponds to the first letter of the currency name. </param>
        /// <param name="value"> The money amount captured in the extracted entity. </param>
        /// <param name="unit"> The unit of the amount captured in the extracted entity. </param>
        internal CurrencyResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string iso4217, double value, string unit) : base(resolutionKind, serializedAdditionalRawData)
        {
            Iso4217 = iso4217;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="CurrencyResolution"/> for deserialization. </summary>
        internal CurrencyResolution()
        {
        }

        /// <summary> The alphabetic code based on another ISO standard, ISO 3166, which lists the codes for country names. The first two letters of the ISO 4217 three-letter code are the same as the code for the country name, and, where possible, the third letter corresponds to the first letter of the currency name. </summary>
        public string Iso4217 { get; }
        /// <summary> The money amount captured in the extracted entity. </summary>
        public double Value { get; }
        /// <summary> The unit of the amount captured in the extracted entity. </summary>
        public string Unit { get; }
    }
}
