// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Conversation PII result item. </summary>
    public partial class ConversationalPiiResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationalPiiResult"/>. </summary>
        /// <param name="id"> Unique, non-empty conversation identifier. </param>
        /// <param name="warnings"> Warnings encountered in processing the document. </param>
        /// <param name="conversationItems"> List of conversationItems. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="warnings"/> or <paramref name="conversationItems"/> is null. </exception>
        internal ConversationalPiiResult(string id, IEnumerable<InputWarning> warnings, IEnumerable<ConversationPiiItemResult> conversationItems)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(warnings, nameof(warnings));
            Argument.AssertNotNull(conversationItems, nameof(conversationItems));

            Id = id;
            Warnings = warnings.ToList();
            ConversationItems = conversationItems.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ConversationalPiiResult"/>. </summary>
        /// <param name="id"> Unique, non-empty conversation identifier. </param>
        /// <param name="warnings"> Warnings encountered in processing the document. </param>
        /// <param name="statistics"> If showStats=true was specified in the request this field will contain information about the conversation payload. </param>
        /// <param name="conversationItems"> List of conversationItems. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationalPiiResult(string id, IReadOnlyList<InputWarning> warnings, ConversationStatistics statistics, IReadOnlyList<ConversationPiiItemResult> conversationItems, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Warnings = warnings;
            Statistics = statistics;
            ConversationItems = conversationItems;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationalPiiResult"/> for deserialization. </summary>
        internal ConversationalPiiResult()
        {
        }

        /// <summary> Unique, non-empty conversation identifier. </summary>
        public string Id { get; }
        /// <summary> Warnings encountered in processing the document. </summary>
        public IReadOnlyList<InputWarning> Warnings { get; }
        /// <summary> If showStats=true was specified in the request this field will contain information about the conversation payload. </summary>
        public ConversationStatistics Statistics { get; }
        /// <summary> List of conversationItems. </summary>
        public IReadOnlyList<ConversationPiiItemResult> ConversationItems { get; }
    }
}
