// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> if showStats=true was specified in the request, this field contains information about the request payload. </summary>
    public partial class ConversationRequestStatistics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationRequestStatistics"/>. </summary>
        /// <param name="documentsCount"> Number of documents submitted in the request. </param>
        /// <param name="validDocumentsCount"> Number of valid documents. This excludes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="erroneousDocumentsCount"> Number of invalid documents. This includes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="transactionsCount"> Number of transactions for the request. </param>
        /// <param name="conversationsCount"> Number of conversations submitted in the request. </param>
        /// <param name="validConversationsCount"> Number of conversation documents. This excludes documents that are empty, over the size limit, or in unsupported languages. </param>
        /// <param name="erroneousConversationsCount"> Number of invalid documents. This includes documents that are empty, over the size limit, or in unsupported languages. </param>
        internal ConversationRequestStatistics(int documentsCount, int validDocumentsCount, int erroneousDocumentsCount, long transactionsCount, int conversationsCount, int validConversationsCount, int erroneousConversationsCount)
        {
            DocumentsCount = documentsCount;
            ValidDocumentsCount = validDocumentsCount;
            ErroneousDocumentsCount = erroneousDocumentsCount;
            TransactionsCount = transactionsCount;
            ConversationsCount = conversationsCount;
            ValidConversationsCount = validConversationsCount;
            ErroneousConversationsCount = erroneousConversationsCount;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationRequestStatistics"/>. </summary>
        /// <param name="documentsCount"> Number of documents submitted in the request. </param>
        /// <param name="validDocumentsCount"> Number of valid documents. This excludes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="erroneousDocumentsCount"> Number of invalid documents. This includes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="transactionsCount"> Number of transactions for the request. </param>
        /// <param name="conversationsCount"> Number of conversations submitted in the request. </param>
        /// <param name="validConversationsCount"> Number of conversation documents. This excludes documents that are empty, over the size limit, or in unsupported languages. </param>
        /// <param name="erroneousConversationsCount"> Number of invalid documents. This includes documents that are empty, over the size limit, or in unsupported languages. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationRequestStatistics(int documentsCount, int validDocumentsCount, int erroneousDocumentsCount, long transactionsCount, int conversationsCount, int validConversationsCount, int erroneousConversationsCount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DocumentsCount = documentsCount;
            ValidDocumentsCount = validDocumentsCount;
            ErroneousDocumentsCount = erroneousDocumentsCount;
            TransactionsCount = transactionsCount;
            ConversationsCount = conversationsCount;
            ValidConversationsCount = validConversationsCount;
            ErroneousConversationsCount = erroneousConversationsCount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationRequestStatistics"/> for deserialization. </summary>
        internal ConversationRequestStatistics()
        {
        }

        /// <summary> Number of documents submitted in the request. </summary>
        public int DocumentsCount { get; }
        /// <summary> Number of valid documents. This excludes empty, over-size limit or non-supported languages documents. </summary>
        public int ValidDocumentsCount { get; }
        /// <summary> Number of invalid documents. This includes empty, over-size limit or non-supported languages documents. </summary>
        public int ErroneousDocumentsCount { get; }
        /// <summary> Number of transactions for the request. </summary>
        public long TransactionsCount { get; }
        /// <summary> Number of conversations submitted in the request. </summary>
        public int ConversationsCount { get; }
        /// <summary> Number of conversation documents. This excludes documents that are empty, over the size limit, or in unsupported languages. </summary>
        public int ValidConversationsCount { get; }
        /// <summary> Number of invalid documents. This includes documents that are empty, over the size limit, or in unsupported languages. </summary>
        public int ErroneousConversationsCount { get; }
    }
}
