// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Describes the PII categories to exclude for detection. If not provided, 'default' categories will be returned which will vary with the language. </summary>
    public readonly partial struct ConversationPiiCategoryExclusions : IEquatable<ConversationPiiCategoryExclusions>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConversationPiiCategoryExclusions"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConversationPiiCategoryExclusions(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddressValue = "Address";
        private const string CreditCardNumberValue = "CreditCardNumber";
        private const string EmailValue = "Email";
        private const string PersonValue = "Person";
        private const string NumericIdentifierValue = "NumericIdentifier";
        private const string PhoneNumberValue = "PhoneNumber";
        private const string UsSocialSecurityNumberValue = "USSocialSecurityNumber";

        /// <summary> Address category. </summary>
        public static ConversationPiiCategoryExclusions Address { get; } = new ConversationPiiCategoryExclusions(AddressValue);
        /// <summary> Credit card number category. </summary>
        public static ConversationPiiCategoryExclusions CreditCardNumber { get; } = new ConversationPiiCategoryExclusions(CreditCardNumberValue);
        /// <summary> Email category. </summary>
        public static ConversationPiiCategoryExclusions Email { get; } = new ConversationPiiCategoryExclusions(EmailValue);
        /// <summary> Person category. </summary>
        public static ConversationPiiCategoryExclusions Person { get; } = new ConversationPiiCategoryExclusions(PersonValue);
        /// <summary> Numeric identifier category. </summary>
        public static ConversationPiiCategoryExclusions NumericIdentifier { get; } = new ConversationPiiCategoryExclusions(NumericIdentifierValue);
        /// <summary> Phone number category. </summary>
        public static ConversationPiiCategoryExclusions PhoneNumber { get; } = new ConversationPiiCategoryExclusions(PhoneNumberValue);
        /// <summary> US social security number category. </summary>
        public static ConversationPiiCategoryExclusions UsSocialSecurityNumber { get; } = new ConversationPiiCategoryExclusions(UsSocialSecurityNumberValue);
        /// <summary> Determines if two <see cref="ConversationPiiCategoryExclusions"/> values are the same. </summary>
        public static bool operator ==(ConversationPiiCategoryExclusions left, ConversationPiiCategoryExclusions right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConversationPiiCategoryExclusions"/> values are not the same. </summary>
        public static bool operator !=(ConversationPiiCategoryExclusions left, ConversationPiiCategoryExclusions right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConversationPiiCategoryExclusions"/>. </summary>
        public static implicit operator ConversationPiiCategoryExclusions(string value) => new ConversationPiiCategoryExclusions(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationPiiCategoryExclusions other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConversationPiiCategoryExclusions other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
