// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Describes the PII categories to return for detection. If not provided, 'default' categories will be returned which will vary with the language. </summary>
    public readonly partial struct ConversationPiiCategories : IEquatable<ConversationPiiCategories>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConversationPiiCategories"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConversationPiiCategories(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddressValue = "Address";
        private const string CreditCardNumberValue = "CreditCardNumber";
        private const string EmailValue = "Email";
        private const string PersonValue = "Person";
        private const string NumericIdentifierValue = "NumericIdentifier";
        private const string PhoneNumberValue = "PhoneNumber";
        private const string UsSocialSecurityNumberValue = "USSocialSecurityNumber";
        private const string MiscellaneousValue = "Miscellaneous";
        private const string AllValue = "All";
        private const string DefaultValue = "Default";

        /// <summary> Address category. </summary>
        public static ConversationPiiCategories Address { get; } = new ConversationPiiCategories(AddressValue);
        /// <summary> Credit card number category. </summary>
        public static ConversationPiiCategories CreditCardNumber { get; } = new ConversationPiiCategories(CreditCardNumberValue);
        /// <summary> Email category. </summary>
        public static ConversationPiiCategories Email { get; } = new ConversationPiiCategories(EmailValue);
        /// <summary> Person category. </summary>
        public static ConversationPiiCategories Person { get; } = new ConversationPiiCategories(PersonValue);
        /// <summary> Numeric identifier category. </summary>
        public static ConversationPiiCategories NumericIdentifier { get; } = new ConversationPiiCategories(NumericIdentifierValue);
        /// <summary> Phone number category. </summary>
        public static ConversationPiiCategories PhoneNumber { get; } = new ConversationPiiCategories(PhoneNumberValue);
        /// <summary> US social security number category. </summary>
        public static ConversationPiiCategories UsSocialSecurityNumber { get; } = new ConversationPiiCategories(UsSocialSecurityNumberValue);
        /// <summary> Miscellaneous category. </summary>
        public static ConversationPiiCategories Miscellaneous { get; } = new ConversationPiiCategories(MiscellaneousValue);
        /// <summary> All categories. </summary>
        public static ConversationPiiCategories All { get; } = new ConversationPiiCategories(AllValue);
        /// <summary> Default categories. </summary>
        public static ConversationPiiCategories Default { get; } = new ConversationPiiCategories(DefaultValue);
        /// <summary> Determines if two <see cref="ConversationPiiCategories"/> values are the same. </summary>
        public static bool operator ==(ConversationPiiCategories left, ConversationPiiCategories right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConversationPiiCategories"/> values are not the same. </summary>
        public static bool operator !=(ConversationPiiCategories left, ConversationPiiCategories right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConversationPiiCategories"/>. </summary>
        public static implicit operator ConversationPiiCategories(string value) => new ConversationPiiCategories(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationPiiCategories other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConversationPiiCategories other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
