// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Conversations.Models
{
    public partial class ConversationPiiActionContent : IUtf8JsonSerializable, IJsonModel<ConversationPiiActionContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConversationPiiActionContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConversationPiiActionContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationPiiActionContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationPiiActionContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(LoggingOptOut))
            {
                writer.WritePropertyName("loggingOptOut"u8);
                writer.WriteBooleanValue(LoggingOptOut.Value);
            }
            if (Optional.IsDefined(ModelVersion))
            {
                writer.WritePropertyName("modelVersion"u8);
                writer.WriteStringValue(ModelVersion);
            }
            if (Optional.IsCollectionDefined(PiiCategories))
            {
                writer.WritePropertyName("piiCategories"u8);
                writer.WriteStartArray();
                foreach (var item in PiiCategories)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(RedactAudioTiming))
            {
                writer.WritePropertyName("redactAudioTiming"u8);
                writer.WriteBooleanValue(RedactAudioTiming.Value);
            }
            if (Optional.IsDefined(RedactionSource))
            {
                writer.WritePropertyName("redactionSource"u8);
                writer.WriteStringValue(RedactionSource.Value.ToString());
            }
            if (Optional.IsDefined(RedactionCharacter))
            {
                writer.WritePropertyName("redactionCharacter"u8);
                writer.WriteStringValue(RedactionCharacter.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ExcludePiiCategories))
            {
                writer.WritePropertyName("excludePiiCategories"u8);
                writer.WriteStartArray();
                foreach (var item in ExcludePiiCategories)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConversationPiiActionContent IJsonModel<ConversationPiiActionContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationPiiActionContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationPiiActionContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConversationPiiActionContent(document.RootElement, options);
        }

        internal static ConversationPiiActionContent DeserializeConversationPiiActionContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? loggingOptOut = default;
            string modelVersion = default;
            IList<ConversationPiiCategories> piiCategories = default;
            bool? redactAudioTiming = default;
            TranscriptContentType? redactionSource = default;
            RedactionCharacter? redactionCharacter = default;
            IList<ConversationPiiCategoryExclusions> excludePiiCategories = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("loggingOptOut"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    loggingOptOut = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("modelVersion"u8))
                {
                    modelVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("piiCategories"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ConversationPiiCategories> array = new List<ConversationPiiCategories>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ConversationPiiCategories(item.GetString()));
                    }
                    piiCategories = array;
                    continue;
                }
                if (property.NameEquals("redactAudioTiming"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redactAudioTiming = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("redactionSource"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redactionSource = new TranscriptContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("redactionCharacter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redactionCharacter = new RedactionCharacter(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("excludePiiCategories"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ConversationPiiCategoryExclusions> array = new List<ConversationPiiCategoryExclusions>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ConversationPiiCategoryExclusions(item.GetString()));
                    }
                    excludePiiCategories = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConversationPiiActionContent(
                loggingOptOut,
                modelVersion,
                piiCategories ?? new ChangeTrackingList<ConversationPiiCategories>(),
                redactAudioTiming,
                redactionSource,
                redactionCharacter,
                excludePiiCategories ?? new ChangeTrackingList<ConversationPiiCategoryExclusions>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConversationPiiActionContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationPiiActionContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConversationPiiActionContent)} does not support writing '{options.Format}' format.");
            }
        }

        ConversationPiiActionContent IPersistableModel<ConversationPiiActionContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationPiiActionContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConversationPiiActionContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConversationPiiActionContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConversationPiiActionContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ConversationPiiActionContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeConversationPiiActionContent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
