// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The input for a conversation language understanding task. </summary>
    public partial class ConversationLanguageUnderstandingInput : AnalyzeConversationInput
    {
        /// <summary> Initializes a new instance of <see cref="ConversationLanguageUnderstandingInput"/>. </summary>
        /// <param name="conversationInput"> The input ConversationItem and its optional parameters. </param>
        /// <param name="actionContent"> Input parameters necessary for a Conversation language understanding task. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversationInput"/> or <paramref name="actionContent"/> is null. </exception>
        public ConversationLanguageUnderstandingInput(ConversationAnalysisInput conversationInput, ConversationLanguageUnderstandingActionContent actionContent)
        {
            Argument.AssertNotNull(conversationInput, nameof(conversationInput));
            Argument.AssertNotNull(actionContent, nameof(actionContent));

            Kind = AnalyzeConversationInputKind.Conversation;
            ConversationInput = conversationInput;
            ActionContent = actionContent;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationLanguageUnderstandingInput"/>. </summary>
        /// <param name="kind"> The base class of a conversation input task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="conversationInput"> The input ConversationItem and its optional parameters. </param>
        /// <param name="actionContent"> Input parameters necessary for a Conversation language understanding task. </param>
        internal ConversationLanguageUnderstandingInput(AnalyzeConversationInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, ConversationAnalysisInput conversationInput, ConversationLanguageUnderstandingActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            ConversationInput = conversationInput;
            ActionContent = actionContent;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationLanguageUnderstandingInput"/> for deserialization. </summary>
        internal ConversationLanguageUnderstandingInput()
        {
        }

        /// <summary> The input ConversationItem and its optional parameters. </summary>
        public ConversationAnalysisInput ConversationInput { get; }
        /// <summary> Input parameters necessary for a Conversation language understanding task. </summary>
        public ConversationLanguageUnderstandingActionContent ActionContent { get; }
    }
}
