// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The intent classification result of a Conversation project. </summary>
    public partial class ConversationIntent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationIntent"/>. </summary>
        /// <param name="category"> A predicted class. </param>
        /// <param name="confidence"> The confidence score of the class from 0.0 to 1.0. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="category"/> is null. </exception>
        internal ConversationIntent(string category, float confidence)
        {
            Argument.AssertNotNull(category, nameof(category));

            Category = category;
            Confidence = confidence;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationIntent"/>. </summary>
        /// <param name="category"> A predicted class. </param>
        /// <param name="confidence"> The confidence score of the class from 0.0 to 1.0. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationIntent(string category, float confidence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Category = category;
            Confidence = confidence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationIntent"/> for deserialization. </summary>
        internal ConversationIntent()
        {
        }

        /// <summary> A predicted class. </summary>
        public string Category { get; }
        /// <summary> The confidence score of the class from 0.0 to 1.0. </summary>
        public float Confidence { get; }
    }
}
