// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary>
    /// Complete ordered set of utterances (spoken or written) by one or more speakers to be used for analysis.
    /// Please note <see cref="ConversationInput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="TextConversation"/> and <see cref="TranscriptConversation"/>.
    /// </summary>
    public abstract partial class ConversationInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationInput"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="language"/> is null. </exception>
        protected ConversationInput(string id, string language)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(language, nameof(language));

            Id = id;
            Language = language;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationInput"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="modality"> modality. </param>
        /// <param name="domain"> domain. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationInput(string id, string language, InputModality modality, ConversationDomain? domain, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Language = language;
            Modality = modality;
            Domain = domain;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationInput"/> for deserialization. </summary>
        internal ConversationInput()
        {
        }

        /// <summary> Unique identifier for the conversation. </summary>
        public string Id { get; }
        /// <summary> Language of the conversation item in BCP-47 format. </summary>
        public string Language { get; }
        /// <summary> modality. </summary>
        internal InputModality Modality { get; set; }
        /// <summary> domain. </summary>
        public ConversationDomain? Domain { get; set; }
    }
}
