// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Conversations.Models
{
    [PersistableModelProxy(typeof(UnknownConversationEntityExtraInformation))]
    public partial class ConversationEntityExtraInformation : IUtf8JsonSerializable, IJsonModel<ConversationEntityExtraInformation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConversationEntityExtraInformation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConversationEntityExtraInformation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationEntityExtraInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationEntityExtraInformation)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("extraInformationKind"u8);
            writer.WriteStringValue(ExtraInformationKind.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConversationEntityExtraInformation IJsonModel<ConversationEntityExtraInformation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationEntityExtraInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationEntityExtraInformation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConversationEntityExtraInformation(document.RootElement, options);
        }

        internal static ConversationEntityExtraInformation DeserializeConversationEntityExtraInformation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("extraInformationKind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "EntitySubtype": return EntitySubtype.DeserializeEntitySubtype(element, options);
                    case "ListKey": return ListKey.DeserializeListKey(element, options);
                    case "RegexKey": return RegexKey.DeserializeRegexKey(element, options);
                }
            }
            return UnknownConversationEntityExtraInformation.DeserializeUnknownConversationEntityExtraInformation(element, options);
        }

        BinaryData IPersistableModel<ConversationEntityExtraInformation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationEntityExtraInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConversationEntityExtraInformation)} does not support writing '{options.Format}' format.");
            }
        }

        ConversationEntityExtraInformation IPersistableModel<ConversationEntityExtraInformation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationEntityExtraInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConversationEntityExtraInformation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConversationEntityExtraInformation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConversationEntityExtraInformation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ConversationEntityExtraInformation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeConversationEntityExtraInformation(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
