// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Enumeration of supported conversational domains. </summary>
    public readonly partial struct ConversationDomain : IEquatable<ConversationDomain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConversationDomain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConversationDomain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FinanceValue = "finance";
        private const string HealthcareValue = "healthcare";
        private const string GenericValue = "generic";

        /// <summary> Enumeration of supported conversational domains. </summary>
        public static ConversationDomain Finance { get; } = new ConversationDomain(FinanceValue);
        /// <summary> Enumeration of supported conversational domains. </summary>
        public static ConversationDomain Healthcare { get; } = new ConversationDomain(HealthcareValue);
        /// <summary> Enumeration of supported conversational domains. </summary>
        public static ConversationDomain Generic { get; } = new ConversationDomain(GenericValue);
        /// <summary> Determines if two <see cref="ConversationDomain"/> values are the same. </summary>
        public static bool operator ==(ConversationDomain left, ConversationDomain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConversationDomain"/> values are not the same. </summary>
        public static bool operator !=(ConversationDomain left, ConversationDomain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConversationDomain"/>. </summary>
        public static implicit operator ConversationDomain(string value) => new ConversationDomain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationDomain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConversationDomain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
