// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> This is a set of request parameters for Customized Conversation projects. </summary>
    public partial class ConversationConfig : AnalysisConfig
    {
        /// <summary> Initializes a new instance of <see cref="ConversationConfig"/>. </summary>
        public ConversationConfig()
        {
            TargetProjectKind = TargetProjectKind.Conversation;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationConfig"/>. </summary>
        /// <param name="targetProjectKind"> The type of a target service. </param>
        /// <param name="apiVersion"> The API version to use when call a specific target service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="callingOptions"> The option to set to call a Conversation project. </param>
        internal ConversationConfig(TargetProjectKind targetProjectKind, string apiVersion, IDictionary<string, BinaryData> serializedAdditionalRawData, ConversationCallingConfig callingOptions) : base(targetProjectKind, apiVersion, serializedAdditionalRawData)
        {
            CallingOptions = callingOptions;
        }

        /// <summary> The option to set to call a Conversation project. </summary>
        public ConversationCallingConfig CallingOptions { get; set; }
    }
}
