// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The input ConversationItem and its optional parameters. </summary>
    public partial class ConversationAnalysisInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationAnalysisInput"/>. </summary>
        /// <param name="conversationItem"> The abstract base for a user input formatted conversation (e.g., Text, Transcript). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversationItem"/> is null. </exception>
        public ConversationAnalysisInput(TextConversationItem conversationItem)
        {
            Argument.AssertNotNull(conversationItem, nameof(conversationItem));

            ConversationItem = conversationItem;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationAnalysisInput"/>. </summary>
        /// <param name="conversationItem"> The abstract base for a user input formatted conversation (e.g., Text, Transcript). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationAnalysisInput(TextConversationItem conversationItem, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConversationItem = conversationItem;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationAnalysisInput"/> for deserialization. </summary>
        internal ConversationAnalysisInput()
        {
        }

        /// <summary> The abstract base for a user input formatted conversation (e.g., Text, Transcript). </summary>
        public TextConversationItem ConversationItem { get; }
    }
}
