// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Contains the state for the tasks that are being executed as part of the submitted job for analyzing a conversation. </summary>
    public partial class ConversationActions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConversationActions"/>. </summary>
        /// <param name="completed"> Count of tasks that finished successfully. </param>
        /// <param name="failed"> Count of tasks that failed. </param>
        /// <param name="inProgress"> Count of tasks that are currently in progress. </param>
        /// <param name="total"> Total count of tasks submitted as part of the job. </param>
        internal ConversationActions(int completed, int failed, int inProgress, int total)
        {
            Completed = completed;
            Failed = failed;
            InProgress = inProgress;
            Total = total;
            Items = new ChangeTrackingList<AnalyzeConversationOperationResult>();
        }

        /// <summary> Initializes a new instance of <see cref="ConversationActions"/>. </summary>
        /// <param name="completed"> Count of tasks that finished successfully. </param>
        /// <param name="failed"> Count of tasks that failed. </param>
        /// <param name="inProgress"> Count of tasks that are currently in progress. </param>
        /// <param name="total"> Total count of tasks submitted as part of the job. </param>
        /// <param name="items">
        /// List of results from tasks (if available).
        /// Please note <see cref="AnalyzeConversationOperationResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationPiiOperationResult"/>, <see cref="SummarizationOperationResult"/> and <see cref="CustomSummarizationOperationResult"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConversationActions(int completed, int failed, int inProgress, int total, IReadOnlyList<AnalyzeConversationOperationResult> items, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Completed = completed;
            Failed = failed;
            InProgress = inProgress;
            Total = total;
            Items = items;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationActions"/> for deserialization. </summary>
        internal ConversationActions()
        {
        }

        /// <summary> Count of tasks that finished successfully. </summary>
        public int Completed { get; }
        /// <summary> Count of tasks that failed. </summary>
        public int Failed { get; }
        /// <summary> Count of tasks that are currently in progress. </summary>
        public int InProgress { get; }
        /// <summary> Total count of tasks submitted as part of the job. </summary>
        public int Total { get; }
        /// <summary>
        /// List of results from tasks (if available).
        /// Please note <see cref="AnalyzeConversationOperationResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationPiiOperationResult"/>, <see cref="SummarizationOperationResult"/> and <see cref="CustomSummarizationOperationResult"/>.
        /// </summary>
        public IReadOnlyList<AnalyzeConversationOperationResult> Items { get; }
    }
}
