// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> The results of a Conversation task. </summary>
    public partial class ConversationActionResult : AnalyzeConversationActionResult
    {
        /// <summary> Initializes a new instance of <see cref="ConversationActionResult"/>. </summary>
        /// <param name="result"> Represents a conversation analysis response. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="result"/> is null. </exception>
        internal ConversationActionResult(AnalyzeConversationResult result)
        {
            Argument.AssertNotNull(result, nameof(result));

            Kind = AnalyzeConversationResultKind.ConversationResult;
            Result = result;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationActionResult"/>. </summary>
        /// <param name="kind"> The base class of a conversation input task result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="result"> Represents a conversation analysis response. </param>
        internal ConversationActionResult(AnalyzeConversationResultKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, AnalyzeConversationResult result) : base(kind, serializedAdditionalRawData)
        {
            Result = result;
        }

        /// <summary> Initializes a new instance of <see cref="ConversationActionResult"/> for deserialization. </summary>
        internal ConversationActionResult()
        {
        }

        /// <summary> Represents a conversation analysis response. </summary>
        public AnalyzeConversationResult Result { get; }
    }
}
