// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> A resolution for boolean expressions. </summary>
    public partial class BooleanResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="BooleanResolution"/>. </summary>
        /// <param name="value"> A resolution for boolean expressions. </param>
        internal BooleanResolution(bool value)
        {
            ResolutionKind = ResolutionKind.BooleanResolution;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="BooleanResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> A resolution for boolean expressions. </param>
        internal BooleanResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, bool value) : base(resolutionKind, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="BooleanResolution"/> for deserialization. </summary>
        internal BooleanResolution()
        {
        }

        /// <summary> A resolution for boolean expressions. </summary>
        public bool Value { get; }
    }
}
