// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents List of Question Answers. </summary>
    public partial class AnswersResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnswersResult"/>. </summary>
        internal AnswersResult()
        {
            Answers = new ChangeTrackingList<KnowledgeBaseAnswer>();
        }

        /// <summary> Initializes a new instance of <see cref="AnswersResult"/>. </summary>
        /// <param name="answers"> Represents Answer Result list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnswersResult(IReadOnlyList<KnowledgeBaseAnswer> answers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Answers = answers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents Answer Result list. </summary>
        public IReadOnlyList<KnowledgeBaseAnswer> Answers { get; }
    }
}
