// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Answer span object of QnA. </summary>
    public partial class AnswerSpan
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnswerSpan"/>. </summary>
        internal AnswerSpan()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AnswerSpan"/>. </summary>
        /// <param name="text"> Predicted text of answer span. </param>
        /// <param name="confidenceScore"> Predicted score of answer span, value ranges from 0 to 1. </param>
        /// <param name="offset"> The answer span offset from the start of answer. </param>
        /// <param name="length"> The length of the answer span. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnswerSpan(string text, double? confidenceScore, int? offset, int? length, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Text = text;
            ConfidenceScore = confidenceScore;
            Offset = offset;
            Length = length;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Predicted text of answer span. </summary>
        public string Text { get; }
        /// <summary> Predicted score of answer span, value ranges from 0 to 1. </summary>
        public double? ConfidenceScore { get; }
        /// <summary> The answer span offset from the start of answer. </summary>
        public int? Offset { get; }
        /// <summary> The length of the answer span. </summary>
        public int? Length { get; }
    }
}
