// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Enumeration of supported conversational task results. </summary>
    internal readonly partial struct AnalyzeConversationResultKind : IEquatable<AnalyzeConversationResultKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationResultKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeConversationResultKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConversationResultValue = "ConversationResult";

        /// <summary> Conversation result task kind. </summary>
        public static AnalyzeConversationResultKind ConversationResult { get; } = new AnalyzeConversationResultKind(ConversationResultValue);
        /// <summary> Determines if two <see cref="AnalyzeConversationResultKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeConversationResultKind left, AnalyzeConversationResultKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeConversationResultKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeConversationResultKind left, AnalyzeConversationResultKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeConversationResultKind"/>. </summary>
        public static implicit operator AnalyzeConversationResultKind(string value) => new AnalyzeConversationResultKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeConversationResultKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeConversationResultKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
