// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents a conversation analysis response. </summary>
    public partial class AnalyzeConversationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationResult"/>. </summary>
        /// <param name="query"> The conversation utterance given by the caller. </param>
        /// <param name="prediction">
        /// The prediction result of a conversation project.
        /// Please note <see cref="PredictionBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationPrediction"/> and <see cref="OrchestrationPrediction"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="query"/> or <paramref name="prediction"/> is null. </exception>
        internal AnalyzeConversationResult(string query, PredictionBase prediction)
        {
            Argument.AssertNotNull(query, nameof(query));
            Argument.AssertNotNull(prediction, nameof(prediction));

            Query = query;
            Prediction = prediction;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationResult"/>. </summary>
        /// <param name="query"> The conversation utterance given by the caller. </param>
        /// <param name="detectedLanguage"> The system detected language for the query in BCP 47 language representation.. </param>
        /// <param name="prediction">
        /// The prediction result of a conversation project.
        /// Please note <see cref="PredictionBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationPrediction"/> and <see cref="OrchestrationPrediction"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalyzeConversationResult(string query, string detectedLanguage, PredictionBase prediction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Query = query;
            DetectedLanguage = detectedLanguage;
            Prediction = prediction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationResult"/> for deserialization. </summary>
        internal AnalyzeConversationResult()
        {
        }

        /// <summary> The conversation utterance given by the caller. </summary>
        public string Query { get; }
        /// <summary> The system detected language for the query in BCP 47 language representation.. </summary>
        public string DetectedLanguage { get; }
        /// <summary>
        /// The prediction result of a conversation project.
        /// Please note <see cref="PredictionBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationPrediction"/> and <see cref="OrchestrationPrediction"/>.
        /// </summary>
        public PredictionBase Prediction { get; }
    }
}
