// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Enumeration of results for supported conversation analysis Results. </summary>
    internal readonly partial struct AnalyzeConversationOperationResultsKind : IEquatable<AnalyzeConversationOperationResultsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationOperationResultsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeConversationOperationResultsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SummarizationOperationResultsValue = "conversationalSummarizationResults";
        private const string PiiOperationResultsValue = "conversationalPIIResults";
        private const string CustomSummarizationOperationResultsValue = "customConversationalSummarizationResults";

        /// <summary> Conversational Summarization Results. </summary>
        public static AnalyzeConversationOperationResultsKind SummarizationOperationResults { get; } = new AnalyzeConversationOperationResultsKind(SummarizationOperationResultsValue);
        /// <summary> Conversational PII Results. </summary>
        public static AnalyzeConversationOperationResultsKind PiiOperationResults { get; } = new AnalyzeConversationOperationResultsKind(PiiOperationResultsValue);
        /// <summary> Custom Conversational Summarization Results. </summary>
        public static AnalyzeConversationOperationResultsKind CustomSummarizationOperationResults { get; } = new AnalyzeConversationOperationResultsKind(CustomSummarizationOperationResultsValue);
        /// <summary> Determines if two <see cref="AnalyzeConversationOperationResultsKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeConversationOperationResultsKind left, AnalyzeConversationOperationResultsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeConversationOperationResultsKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeConversationOperationResultsKind left, AnalyzeConversationOperationResultsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeConversationOperationResultsKind"/>. </summary>
        public static implicit operator AnalyzeConversationOperationResultsKind(string value) => new AnalyzeConversationOperationResultsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeConversationOperationResultsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeConversationOperationResultsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
