// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary>
    /// Container for results of all tasks in the conversation job.
    /// Please note <see cref="AnalyzeConversationOperationResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ConversationPiiOperationResult"/>, <see cref="SummarizationOperationResult"/> and <see cref="CustomSummarizationOperationResult"/>.
    /// </summary>
    public abstract partial class AnalyzeConversationOperationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        protected AnalyzeConversationOperationResult(DateTimeOffset lastUpdateDateTime, ConversationActionState status)
        {
            LastUpdateDateTime = lastUpdateDateTime;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> discriminator kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalyzeConversationOperationResult(DateTimeOffset lastUpdateDateTime, ConversationActionState status, string name, AnalyzeConversationOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LastUpdateDateTime = lastUpdateDateTime;
            Status = status;
            Name = name;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationOperationResult"/> for deserialization. </summary>
        internal AnalyzeConversationOperationResult()
        {
        }

        /// <summary> The last updated time in UTC for the task. </summary>
        public DateTimeOffset LastUpdateDateTime { get; }
        /// <summary> The status of the task at the mentioned last update time. </summary>
        public ConversationActionState Status { get; }
        /// <summary> task name. </summary>
        public string Name { get; }
        /// <summary> discriminator kind. </summary>
        internal AnalyzeConversationOperationResultsKind Kind { get; set; }
    }
}
