// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Enumeration of supported analysis tasks on a collection of conversations. </summary>
    internal readonly partial struct AnalyzeConversationOperationActionKind : IEquatable<AnalyzeConversationOperationActionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationOperationActionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeConversationOperationActionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConversationalSummarizationTaskValue = "ConversationalSummarizationTask";
        private const string ConversationalPIITaskValue = "ConversationalPIITask";
        private const string CustomConversationalSummarizationTaskValue = "CustomConversationalSummarizationTask";

        /// <summary> Conversational Summarization Task. </summary>
        public static AnalyzeConversationOperationActionKind ConversationalSummarizationTask { get; } = new AnalyzeConversationOperationActionKind(ConversationalSummarizationTaskValue);
        /// <summary> Conversational PII Task. </summary>
        public static AnalyzeConversationOperationActionKind ConversationalPIITask { get; } = new AnalyzeConversationOperationActionKind(ConversationalPIITaskValue);
        /// <summary> Custom Conversational Summarization Task. </summary>
        public static AnalyzeConversationOperationActionKind CustomConversationalSummarizationTask { get; } = new AnalyzeConversationOperationActionKind(CustomConversationalSummarizationTaskValue);
        /// <summary> Determines if two <see cref="AnalyzeConversationOperationActionKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeConversationOperationActionKind left, AnalyzeConversationOperationActionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeConversationOperationActionKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeConversationOperationActionKind left, AnalyzeConversationOperationActionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeConversationOperationActionKind"/>. </summary>
        public static implicit operator AnalyzeConversationOperationActionKind(string value) => new AnalyzeConversationOperationActionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeConversationOperationActionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeConversationOperationActionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
