// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Enumeration of supported Conversation tasks. </summary>
    internal readonly partial struct AnalyzeConversationInputKind : IEquatable<AnalyzeConversationInputKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeConversationInputKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeConversationInputKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConversationValue = "Conversation";

        /// <summary> Conversation task kind. </summary>
        public static AnalyzeConversationInputKind Conversation { get; } = new AnalyzeConversationInputKind(ConversationValue);
        /// <summary> Determines if two <see cref="AnalyzeConversationInputKind"/> values are the same. </summary>
        public static bool operator ==(AnalyzeConversationInputKind left, AnalyzeConversationInputKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeConversationInputKind"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeConversationInputKind left, AnalyzeConversationInputKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeConversationInputKind"/>. </summary>
        public static implicit operator AnalyzeConversationInputKind(string value) => new AnalyzeConversationInputKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeConversationInputKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeConversationInputKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
