// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Conversations.Models
{
    /// <summary> Represents the Age entity resolution model. </summary>
    public partial class AgeResolution : ResolutionBase
    {
        /// <summary> Initializes a new instance of <see cref="AgeResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Age Unit of measurement. </param>
        internal AgeResolution(double value, AgeUnit unit)
        {
            ResolutionKind = ResolutionKind.AgeResolution;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="AgeResolution"/>. </summary>
        /// <param name="resolutionKind"> The entity resolution object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Age Unit of measurement. </param>
        internal AgeResolution(ResolutionKind resolutionKind, IDictionary<string, BinaryData> serializedAdditionalRawData, double value, AgeUnit unit) : base(resolutionKind, serializedAdditionalRawData)
        {
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="AgeResolution"/> for deserialization. </summary>
        internal AgeResolution()
        {
        }

        /// <summary> The numeric value that the extracted text denotes. </summary>
        public double Value { get; }
        /// <summary> The Age Unit of measurement. </summary>
        public AgeUnit Unit { get; }
    }
}
