// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.AI.Language.Conversations.Models;

namespace Azure.AI.Language.Conversations
{
    /// <summary> Model factory for models. </summary>
    public static partial class ConversationsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ConversationLanguageUnderstandingInput"/>. </summary>
        /// <param name="conversationInput"> The input ConversationItem and its optional parameters. </param>
        /// <param name="actionContent"> Input parameters necessary for a Conversation language understanding task. </param>
        /// <returns> A new <see cref="Models.ConversationLanguageUnderstandingInput"/> instance for mocking. </returns>
        public static ConversationLanguageUnderstandingInput ConversationLanguageUnderstandingInput(ConversationAnalysisInput conversationInput = null, ConversationLanguageUnderstandingActionContent actionContent = null)
        {
            return new ConversationLanguageUnderstandingInput(AnalyzeConversationInputKind.Conversation, serializedAdditionalRawData: null, conversationInput, actionContent);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TextConversationItem"/>. </summary>
        /// <param name="id"> The ID of a conversation item. </param>
        /// <param name="participantId"> The participant ID of a conversation item. </param>
        /// <param name="language"> The override language of a conversation item in BCP 47 language representation. </param>
        /// <param name="modality"> Enumeration of supported conversational modalities. </param>
        /// <param name="role"> Role of the participant. </param>
        /// <param name="text"> The text input. </param>
        /// <returns> A new <see cref="Models.TextConversationItem"/> instance for mocking. </returns>
        public static TextConversationItem TextConversationItem(string id = null, string participantId = null, string language = null, InputModality? modality = null, ParticipantRole? role = null, string text = null)
        {
            return new TextConversationItem(
                id,
                participantId,
                language,
                modality,
                role,
                text,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationLanguageUnderstandingActionContent"/>. </summary>
        /// <param name="projectName"> The name of the project to use. </param>
        /// <param name="deploymentName"> The name of the deployment to use. </param>
        /// <param name="verbose"> If true, the service will return more detailed information in the response. </param>
        /// <param name="isLoggingEnabled"> If true, the service will keep the query for further review. </param>
        /// <param name="stringIndexType"> Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see https://aka.ms/text-analytics-offsets. </param>
        /// <param name="directTarget"> The name of a target project to forward the request to. </param>
        /// <param name="targetProjectParameters">
        /// A dictionary representing the parameters for each target project.
        /// Please note <see cref="AnalysisConfig"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConversationConfig"/>, <see cref="LuisConfig"/> and <see cref="QuestionAnsweringConfig"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ConversationLanguageUnderstandingActionContent"/> instance for mocking. </returns>
        public static ConversationLanguageUnderstandingActionContent ConversationLanguageUnderstandingActionContent(string projectName = null, string deploymentName = null, bool? verbose = null, bool? isLoggingEnabled = null, StringIndexType? stringIndexType = null, string directTarget = null, IDictionary<string, AnalysisConfig> targetProjectParameters = null)
        {
            targetProjectParameters ??= new Dictionary<string, AnalysisConfig>();

            return new ConversationLanguageUnderstandingActionContent(
                projectName,
                deploymentName,
                verbose,
                isLoggingEnabled,
                stringIndexType,
                directTarget,
                targetProjectParameters,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KnowledgeBaseAnswerContext"/>. </summary>
        /// <param name="previousQnaId"> Previous turn top answer result QnA ID. </param>
        /// <param name="previousQuestion"> Previous user query. </param>
        /// <returns> A new <see cref="Models.KnowledgeBaseAnswerContext"/> instance for mocking. </returns>
        public static KnowledgeBaseAnswerContext KnowledgeBaseAnswerContext(int previousQnaId = default, string previousQuestion = null)
        {
            return new KnowledgeBaseAnswerContext(previousQnaId, previousQuestion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationActionResult"/>. </summary>
        /// <param name="result"> Represents a conversation analysis response. </param>
        /// <returns> A new <see cref="Models.ConversationActionResult"/> instance for mocking. </returns>
        public static ConversationActionResult ConversationActionResult(AnalyzeConversationResult result = null)
        {
            return new ConversationActionResult(AnalyzeConversationResultKind.ConversationResult, serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalyzeConversationResult"/>. </summary>
        /// <param name="query"> The conversation utterance given by the caller. </param>
        /// <param name="detectedLanguage"> The system detected language for the query in BCP 47 language representation.. </param>
        /// <param name="prediction">
        /// The prediction result of a conversation project.
        /// Please note <see cref="Models.PredictionBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConversationPrediction"/> and <see cref="Models.OrchestrationPrediction"/>.
        /// </param>
        /// <returns> A new <see cref="Models.AnalyzeConversationResult"/> instance for mocking. </returns>
        public static AnalyzeConversationResult AnalyzeConversationResult(string query = null, string detectedLanguage = null, PredictionBase prediction = null)
        {
            return new AnalyzeConversationResult(query, detectedLanguage, prediction, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictionBase"/>. </summary>
        /// <param name="projectKind"> The type of the project. </param>
        /// <param name="topIntent"> The intent with the highest score. </param>
        /// <returns> A new <see cref="Models.PredictionBase"/> instance for mocking. </returns>
        public static PredictionBase PredictionBase(string projectKind = null, string topIntent = null)
        {
            return new UnknownPredictionBase(projectKind == null ? default : new ProjectKind(projectKind), topIntent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationPrediction"/>. </summary>
        /// <param name="topIntent"> The intent with the highest score. </param>
        /// <param name="intents"> The intent classification results. </param>
        /// <param name="entities"> The entity extraction results. </param>
        /// <returns> A new <see cref="Models.ConversationPrediction"/> instance for mocking. </returns>
        public static ConversationPrediction ConversationPrediction(string topIntent = null, IEnumerable<ConversationIntent> intents = null, IEnumerable<ConversationEntity> entities = null)
        {
            intents ??= new List<ConversationIntent>();
            entities ??= new List<ConversationEntity>();

            return new ConversationPrediction(ProjectKind.Conversation, topIntent, serializedAdditionalRawData: null, intents?.ToList(), entities?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationIntent"/>. </summary>
        /// <param name="category"> A predicted class. </param>
        /// <param name="confidence"> The confidence score of the class from 0.0 to 1.0. </param>
        /// <returns> A new <see cref="Models.ConversationIntent"/> instance for mocking. </returns>
        public static ConversationIntent ConversationIntent(string category = null, float confidence = default)
        {
            return new ConversationIntent(category, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationEntity"/>. </summary>
        /// <param name="category"> The entity category. </param>
        /// <param name="text"> The predicted entity text. </param>
        /// <param name="offset"> The starting index of this entity in the query. </param>
        /// <param name="length"> The length of the text. </param>
        /// <param name="confidence"> The entity confidence score. </param>
        /// <param name="resolutions">
        /// The collection of entity resolution objects.
        /// Please note <see cref="ResolutionBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AgeResolution"/>, <see cref="Models.AreaResolution"/>, <see cref="Models.BooleanResolution"/>, <see cref="Models.CurrencyResolution"/>, <see cref="Models.DateTimeResolution"/>, <see cref="Models.InformationResolution"/>, <see cref="Models.LengthResolution"/>, <see cref="Models.NumberResolution"/>, <see cref="Models.NumericRangeResolution"/>, <see cref="Models.OrdinalResolution"/>, <see cref="Models.SpeedResolution"/>, <see cref="Models.TemperatureResolution"/>, <see cref="Models.TemporalSpanResolution"/>, <see cref="Models.VolumeResolution"/> and <see cref="Models.WeightResolution"/>.
        /// </param>
        /// <param name="extraInformation">
        /// The collection of entity extra information objects.
        /// Please note <see cref="ConversationEntityExtraInformation"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.EntitySubtype"/>, <see cref="Models.ListKey"/> and <see cref="Models.RegexKey"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ConversationEntity"/> instance for mocking. </returns>
        public static ConversationEntity ConversationEntity(string category = null, string text = null, int offset = default, int length = default, float confidence = default, IEnumerable<ResolutionBase> resolutions = null, IEnumerable<ConversationEntityExtraInformation> extraInformation = null)
        {
            resolutions ??= new List<ResolutionBase>();
            extraInformation ??= new List<ConversationEntityExtraInformation>();

            return new ConversationEntity(
                category,
                text,
                offset,
                length,
                confidence,
                resolutions?.ToList(),
                extraInformation?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AgeResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Age Unit of measurement. </param>
        /// <returns> A new <see cref="Models.AgeResolution"/> instance for mocking. </returns>
        public static AgeResolution AgeResolution(double value = default, AgeUnit unit = default)
        {
            return new AgeResolution(ResolutionKind.AgeResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VolumeResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The Volume Unit of measurement. </param>
        /// <returns> A new <see cref="Models.VolumeResolution"/> instance for mocking. </returns>
        public static VolumeResolution VolumeResolution(double value = default, VolumeUnit unit = default)
        {
            return new VolumeResolution(ResolutionKind.VolumeResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SpeedResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The speed Unit of measurement. </param>
        /// <returns> A new <see cref="Models.SpeedResolution"/> instance for mocking. </returns>
        public static SpeedResolution SpeedResolution(double value = default, SpeedUnit unit = default)
        {
            return new SpeedResolution(ResolutionKind.SpeedResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AreaResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The area Unit of measurement. </param>
        /// <returns> A new <see cref="Models.AreaResolution"/> instance for mocking. </returns>
        public static AreaResolution AreaResolution(double value = default, AreaUnit unit = default)
        {
            return new AreaResolution(ResolutionKind.AreaResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LengthResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The length Unit of measurement. </param>
        /// <returns> A new <see cref="Models.LengthResolution"/> instance for mocking. </returns>
        public static LengthResolution LengthResolution(double value = default, LengthUnit unit = default)
        {
            return new LengthResolution(ResolutionKind.LengthResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InformationResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The information (data) Unit of measurement. </param>
        /// <returns> A new <see cref="Models.InformationResolution"/> instance for mocking. </returns>
        public static InformationResolution InformationResolution(double value = default, InformationUnit unit = default)
        {
            return new InformationResolution(ResolutionKind.InformationResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemperatureResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The temperature Unit of measurement. </param>
        /// <returns> A new <see cref="Models.TemperatureResolution"/> instance for mocking. </returns>
        public static TemperatureResolution TemperatureResolution(double value = default, TemperatureUnit unit = default)
        {
            return new TemperatureResolution(ResolutionKind.TemperatureResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeightResolution"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> The weight Unit of measurement. </param>
        /// <returns> A new <see cref="Models.WeightResolution"/> instance for mocking. </returns>
        public static WeightResolution WeightResolution(double value = default, WeightUnit unit = default)
        {
            return new WeightResolution(ResolutionKind.WeightResolution, serializedAdditionalRawData: null, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CurrencyResolution"/>. </summary>
        /// <param name="iso4217"> The alphabetic code based on another ISO standard, ISO 3166, which lists the codes for country names. The first two letters of the ISO 4217 three-letter code are the same as the code for the country name, and, where possible, the third letter corresponds to the first letter of the currency name. </param>
        /// <param name="value"> The money amount captured in the extracted entity. </param>
        /// <param name="unit"> The unit of the amount captured in the extracted entity. </param>
        /// <returns> A new <see cref="Models.CurrencyResolution"/> instance for mocking. </returns>
        public static CurrencyResolution CurrencyResolution(string iso4217 = null, double value = default, string unit = null)
        {
            return new CurrencyResolution(ResolutionKind.CurrencyResolution, serializedAdditionalRawData: null, iso4217, value, unit);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BooleanResolution"/>. </summary>
        /// <param name="value"> A resolution for boolean expressions. </param>
        /// <returns> A new <see cref="Models.BooleanResolution"/> instance for mocking. </returns>
        public static BooleanResolution BooleanResolution(bool value = default)
        {
            return new BooleanResolution(ResolutionKind.BooleanResolution, serializedAdditionalRawData: null, value);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DateTimeResolution"/>. </summary>
        /// <param name="timex"> An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="dateTimeSubKind"> The DateTime SubKind. </param>
        /// <param name="value"> The actual time that the extracted text denote. </param>
        /// <param name="modifier"> An optional modifier of a date/time instance. </param>
        /// <returns> A new <see cref="Models.DateTimeResolution"/> instance for mocking. </returns>
        public static DateTimeResolution DateTimeResolution(string timex = null, DateTimeSubKind dateTimeSubKind = default, string value = null, TemporalModifier? modifier = null)
        {
            return new DateTimeResolution(
                ResolutionKind.DateTimeResolution,
                serializedAdditionalRawData: null,
                timex,
                dateTimeSubKind,
                value,
                modifier);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NumberResolution"/>. </summary>
        /// <param name="numberKind"> The type of the extracted number entity. </param>
        /// <param name="value"> A numeric representation of what the extracted text denotes. </param>
        /// <returns> A new <see cref="Models.NumberResolution"/> instance for mocking. </returns>
        public static NumberResolution NumberResolution(NumberKind numberKind = default, double value = default)
        {
            return new NumberResolution(ResolutionKind.NumberResolution, serializedAdditionalRawData: null, numberKind, value);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OrdinalResolution"/>. </summary>
        /// <param name="offset"> The offset with respect to the reference (e.g., offset = -1 indicates the second to last). </param>
        /// <param name="relativeTo"> The reference point that the ordinal number denotes. </param>
        /// <param name="value"> A simple arithmetic expression that the ordinal denotes. </param>
        /// <returns> A new <see cref="Models.OrdinalResolution"/> instance for mocking. </returns>
        public static OrdinalResolution OrdinalResolution(string offset = null, RelativeTo relativeTo = default, string value = null)
        {
            return new OrdinalResolution(ResolutionKind.OrdinalResolution, serializedAdditionalRawData: null, offset, relativeTo, value);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemporalSpanResolution"/>. </summary>
        /// <param name="begin"> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="end"> represents the resolution of a date and/or time span. An extended ISO 8601 date/time representation as described in (https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml). </param>
        /// <param name="duration"> An optional duration value formatted based on the ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601#Durations). </param>
        /// <param name="modifier"> An optional modifier of a date/time instance. </param>
        /// <param name="timex"> An optional triplet containing the beginning, the end, and the duration all stated as ISO 8601 formatted strings. </param>
        /// <returns> A new <see cref="Models.TemporalSpanResolution"/> instance for mocking. </returns>
        public static TemporalSpanResolution TemporalSpanResolution(string begin = null, string end = null, string duration = null, TemporalModifier? modifier = null, string timex = null)
        {
            return new TemporalSpanResolution(
                ResolutionKind.TemporalSpanResolution,
                serializedAdditionalRawData: null,
                begin,
                end,
                duration,
                modifier,
                timex);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NumericRangeResolution"/>. </summary>
        /// <param name="rangeKind"> The kind of range that the resolution object represents. </param>
        /// <param name="minimum"> The beginning value of  the interval. </param>
        /// <param name="maximum"> The ending value of the interval. </param>
        /// <returns> A new <see cref="Models.NumericRangeResolution"/> instance for mocking. </returns>
        public static NumericRangeResolution NumericRangeResolution(RangeKind rangeKind = default, double minimum = default, double maximum = default)
        {
            return new NumericRangeResolution(ResolutionKind.NumericRangeResolution, serializedAdditionalRawData: null, rangeKind, minimum, maximum);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EntitySubtype"/>. </summary>
        /// <param name="value"> The Subtype of an extracted entity type. </param>
        /// <param name="tags"> List of entity tags. Tags express similarities between entity categories for the extracted entity type. </param>
        /// <returns> A new <see cref="Models.EntitySubtype"/> instance for mocking. </returns>
        public static EntitySubtype EntitySubtype(string value = null, IEnumerable<EntityTag> tags = null)
        {
            tags ??= new List<EntityTag>();

            return new EntitySubtype(ExtraInformationKind.EntitySubtype, serializedAdditionalRawData: null, value, tags?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.EntityTag"/>. </summary>
        /// <param name="name"> The name of the tag. </param>
        /// <param name="confidenceScore"> The confidence score of the tag for the extracted entity between 0.0 and 1.0. </param>
        /// <returns> A new <see cref="Models.EntityTag"/> instance for mocking. </returns>
        public static EntityTag EntityTag(string name = null, double? confidenceScore = null)
        {
            return new EntityTag(name, confidenceScore, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ListKey"/>. </summary>
        /// <param name="key"> The canonical form of the extracted entity. </param>
        /// <returns> A new <see cref="Models.ListKey"/> instance for mocking. </returns>
        public static ListKey ListKey(string key = null)
        {
            return new ListKey(ExtraInformationKind.ListKey, serializedAdditionalRawData: null, key);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RegexKey"/>. </summary>
        /// <param name="key"> The key of the regex pattern used in extracting the entity. </param>
        /// <param name="regexPattern"> The .NET regex pattern used in extracting the entity. Please visit https://docs.microsoft.com/dotnet/standard/base-types/regular-expressions for more information about .NET regular expressions. </param>
        /// <returns> A new <see cref="Models.RegexKey"/> instance for mocking. </returns>
        public static RegexKey RegexKey(string key = null, string regexPattern = null)
        {
            return new RegexKey(ExtraInformationKind.RegexKey, serializedAdditionalRawData: null, key, regexPattern);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OrchestrationPrediction"/>. </summary>
        /// <param name="topIntent"> The intent with the highest score. </param>
        /// <param name="intents">
        /// A dictionary that contains all intents. A key is an intent name and a value is its confidence score and target type. The top intent's value also contains the actual response from the target project.
        /// Please note <see cref="Models.TargetIntentResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConversationTargetIntentResult"/>, <see cref="Models.LuisTargetIntentResult"/>, <see cref="Models.NoneLinkedTargetIntentResult"/> and <see cref="Models.QuestionAnsweringTargetIntentResult"/>.
        /// </param>
        /// <returns> A new <see cref="Models.OrchestrationPrediction"/> instance for mocking. </returns>
        public static OrchestrationPrediction OrchestrationPrediction(string topIntent = null, IReadOnlyDictionary<string, TargetIntentResult> intents = null)
        {
            intents ??= new Dictionary<string, TargetIntentResult>();

            return new OrchestrationPrediction(ProjectKind.Orchestration, topIntent, serializedAdditionalRawData: null, intents);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TargetIntentResult"/>. </summary>
        /// <param name="targetProjectKind"> This is the base class of an intent prediction. </param>
        /// <param name="apiVersion"> The API version used to call a target service. </param>
        /// <param name="confidence"> The prediction score and it ranges from 0.0 to 1.0. </param>
        /// <returns> A new <see cref="Models.TargetIntentResult"/> instance for mocking. </returns>
        public static TargetIntentResult TargetIntentResult(string targetProjectKind = null, string apiVersion = null, double confidence = default)
        {
            return new UnknownTargetIntentResult(targetProjectKind == null ? default : new TargetProjectKind(targetProjectKind), apiVersion, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NoneLinkedTargetIntentResult"/>. </summary>
        /// <param name="apiVersion"> The API version used to call a target service. </param>
        /// <param name="confidence"> The prediction score and it ranges from 0.0 to 1.0. </param>
        /// <param name="result"> The actual response from a Conversation project. </param>
        /// <returns> A new <see cref="Models.NoneLinkedTargetIntentResult"/> instance for mocking. </returns>
        public static NoneLinkedTargetIntentResult NoneLinkedTargetIntentResult(string apiVersion = null, double confidence = default, ConversationResult result = null)
        {
            return new NoneLinkedTargetIntentResult(TargetProjectKind.NonLinked, apiVersion, confidence, serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationResult"/>. </summary>
        /// <param name="query"> The same query given in request. </param>
        /// <param name="detectedLanguage"> The detected language from the query in BCP 47 language representation. </param>
        /// <param name="prediction"> The predicted result for the query. </param>
        /// <returns> A new <see cref="Models.ConversationResult"/> instance for mocking. </returns>
        public static ConversationResult ConversationResult(string query = null, string detectedLanguage = null, ConversationPrediction prediction = null)
        {
            return new ConversationResult(query, detectedLanguage, prediction, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationTargetIntentResult"/>. </summary>
        /// <param name="apiVersion"> The API version used to call a target service. </param>
        /// <param name="confidence"> The prediction score and it ranges from 0.0 to 1.0. </param>
        /// <param name="result"> The actual response from a Conversation project. </param>
        /// <returns> A new <see cref="Models.ConversationTargetIntentResult"/> instance for mocking. </returns>
        public static ConversationTargetIntentResult ConversationTargetIntentResult(string apiVersion = null, double confidence = default, ConversationResult result = null)
        {
            return new ConversationTargetIntentResult(TargetProjectKind.Conversation, apiVersion, confidence, serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LuisTargetIntentResult"/>. </summary>
        /// <param name="apiVersion"> The API version used to call a target service. </param>
        /// <param name="confidence"> The prediction score and it ranges from 0.0 to 1.0. </param>
        /// <param name="result"> The actual response from a LUIS Generally Available application. </param>
        /// <returns> A new <see cref="Models.LuisTargetIntentResult"/> instance for mocking. </returns>
        public static LuisTargetIntentResult LuisTargetIntentResult(string apiVersion = null, double confidence = default, LuisResult result = null)
        {
            return new LuisTargetIntentResult(TargetProjectKind.Luis, apiVersion, confidence, serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LuisResult"/>. </summary>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.LuisResult"/> instance for mocking. </returns>
        public static LuisResult LuisResult(IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new LuisResult(additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuestionAnsweringTargetIntentResult"/>. </summary>
        /// <param name="apiVersion"> The API version used to call a target service. </param>
        /// <param name="confidence"> The prediction score and it ranges from 0.0 to 1.0. </param>
        /// <param name="result"> The generated answer by a Question Answering KB. </param>
        /// <returns> A new <see cref="Models.QuestionAnsweringTargetIntentResult"/> instance for mocking. </returns>
        public static QuestionAnsweringTargetIntentResult QuestionAnsweringTargetIntentResult(string apiVersion = null, double confidence = default, AnswersResult result = null)
        {
            return new QuestionAnsweringTargetIntentResult(TargetProjectKind.QuestionAnswering, apiVersion, confidence, serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnswersResult"/>. </summary>
        /// <param name="answers"> Represents Answer Result list. </param>
        /// <returns> A new <see cref="Models.AnswersResult"/> instance for mocking. </returns>
        public static AnswersResult AnswersResult(IEnumerable<KnowledgeBaseAnswer> answers = null)
        {
            answers ??= new List<KnowledgeBaseAnswer>();

            return new AnswersResult(answers?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KnowledgeBaseAnswer"/>. </summary>
        /// <param name="questions"> List of questions associated with the answer. </param>
        /// <param name="answer"> Answer text. </param>
        /// <param name="confidence"> Answer confidence score, value ranges from 0 to 1. </param>
        /// <param name="qnaId"> ID of the QnA result. </param>
        /// <param name="source"> Source of QnA result. </param>
        /// <param name="metadata"> Metadata associated with the answer, useful to categorize or filter question answers. </param>
        /// <param name="dialog"> Dialog associated with Answer. </param>
        /// <param name="shortAnswer"> Answer span object of QnA with respect to user's question. </param>
        /// <returns> A new <see cref="Models.KnowledgeBaseAnswer"/> instance for mocking. </returns>
        public static KnowledgeBaseAnswer KnowledgeBaseAnswer(IEnumerable<string> questions = null, string answer = null, double? confidence = null, int? qnaId = null, string source = null, IReadOnlyDictionary<string, string> metadata = null, KnowledgeBaseAnswerDialog dialog = null, AnswerSpan shortAnswer = null)
        {
            questions ??= new List<string>();
            metadata ??= new Dictionary<string, string>();

            return new KnowledgeBaseAnswer(
                questions?.ToList(),
                answer,
                confidence,
                qnaId,
                source,
                metadata,
                dialog,
                shortAnswer,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KnowledgeBaseAnswerDialog"/>. </summary>
        /// <param name="isContextOnly"> To mark if a prompt is relevant only with a previous question or not. If true, do not include this QnA as search result for queries without context; otherwise, if false, ignores context and includes this QnA in search result. </param>
        /// <param name="prompts"> List of prompts associated with the answer. </param>
        /// <returns> A new <see cref="Models.KnowledgeBaseAnswerDialog"/> instance for mocking. </returns>
        public static KnowledgeBaseAnswerDialog KnowledgeBaseAnswerDialog(bool? isContextOnly = null, IEnumerable<KnowledgeBaseAnswerPrompt> prompts = null)
        {
            prompts ??= new List<KnowledgeBaseAnswerPrompt>();

            return new KnowledgeBaseAnswerDialog(isContextOnly, prompts?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KnowledgeBaseAnswerPrompt"/>. </summary>
        /// <param name="displayOrder"> Index of the prompt - used in ordering of the prompts. </param>
        /// <param name="qnaId"> QnA ID corresponding to the prompt. </param>
        /// <param name="displayText"> Text displayed to represent a follow up question prompt. </param>
        /// <returns> A new <see cref="Models.KnowledgeBaseAnswerPrompt"/> instance for mocking. </returns>
        public static KnowledgeBaseAnswerPrompt KnowledgeBaseAnswerPrompt(int? displayOrder = null, int? qnaId = null, string displayText = null)
        {
            return new KnowledgeBaseAnswerPrompt(displayOrder, qnaId, displayText, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnswerSpan"/>. </summary>
        /// <param name="text"> Predicted text of answer span. </param>
        /// <param name="confidenceScore"> Predicted score of answer span, value ranges from 0 to 1. </param>
        /// <param name="offset"> The answer span offset from the start of answer. </param>
        /// <param name="length"> The length of the answer span. </param>
        /// <returns> A new <see cref="Models.AnswerSpan"/> instance for mocking. </returns>
        public static AnswerSpan AnswerSpan(string text = null, double? confidenceScore = null, int? offset = null, int? length = null)
        {
            return new AnswerSpan(text, confidenceScore, offset, length, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationError"/>. </summary>
        /// <param name="code"> One of a server-defined set of error codes. </param>
        /// <param name="message"> A human-readable representation of the error. </param>
        /// <param name="target"> The target of the error. </param>
        /// <param name="details"> An array of details about specific errors that led to this reported error. </param>
        /// <param name="innererror"> An object containing more specific information than the current object about the error. </param>
        /// <returns> A new <see cref="Models.ConversationError"/> instance for mocking. </returns>
        public static ConversationError ConversationError(ConversationErrorCode code = default, string message = null, string target = null, IEnumerable<ConversationError> details = null, InnerErrorModel innererror = null)
        {
            details ??= new List<ConversationError>();

            return new ConversationError(
                code,
                message,
                target,
                details?.ToList(),
                innererror,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InnerErrorModel"/>. </summary>
        /// <param name="code"> One of a server-defined set of error codes. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="details"> Error details. </param>
        /// <param name="target"> Error target. </param>
        /// <param name="innererror"> An object containing more specific information than the current object about the error. </param>
        /// <returns> A new <see cref="Models.InnerErrorModel"/> instance for mocking. </returns>
        public static InnerErrorModel InnerErrorModel(InnerErrorCode code = default, string message = null, IReadOnlyDictionary<string, string> details = null, string target = null, InnerErrorModel innererror = null)
        {
            details ??= new Dictionary<string, string>();

            return new InnerErrorModel(
                code,
                message,
                details,
                target,
                innererror,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalyzeConversationOperationState"/>. </summary>
        /// <param name="displayName"> display name. </param>
        /// <param name="createdDateTime"> Date and time job created. </param>
        /// <param name="expirationDateTime"> Date and time job expires. </param>
        /// <param name="jobId"> job ID. </param>
        /// <param name="lastUpdatedDateTime"> last updated date and time. </param>
        /// <param name="status"> status. </param>
        /// <param name="errors"> errors. </param>
        /// <param name="nextLink"> next link. </param>
        /// <param name="actions"> Contains the state for the tasks that are being executed as part of the submitted job for analyzing a conversation. </param>
        /// <param name="statistics"> Contains the statistics for the submitted job. </param>
        /// <returns> A new <see cref="Models.AnalyzeConversationOperationState"/> instance for mocking. </returns>
        public static AnalyzeConversationOperationState AnalyzeConversationOperationState(string displayName = null, DateTimeOffset createdDateTime = default, DateTimeOffset? expirationDateTime = null, Guid jobId = default, DateTimeOffset lastUpdatedDateTime = default, ConversationActionState status = default, IEnumerable<ConversationError> errors = null, string nextLink = null, ConversationActions actions = null, ConversationRequestStatistics statistics = null)
        {
            errors ??= new List<ConversationError>();

            return new AnalyzeConversationOperationState(
                displayName,
                createdDateTime,
                expirationDateTime,
                jobId,
                lastUpdatedDateTime,
                status,
                errors?.ToList(),
                nextLink,
                actions,
                statistics,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationActions"/>. </summary>
        /// <param name="completed"> Count of tasks that finished successfully. </param>
        /// <param name="failed"> Count of tasks that failed. </param>
        /// <param name="inProgress"> Count of tasks that are currently in progress. </param>
        /// <param name="total"> Total count of tasks submitted as part of the job. </param>
        /// <param name="items">
        /// List of results from tasks (if available).
        /// Please note <see cref="Models.AnalyzeConversationOperationResult"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConversationPiiOperationResult"/>, <see cref="Models.SummarizationOperationResult"/> and <see cref="Models.CustomSummarizationOperationResult"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ConversationActions"/> instance for mocking. </returns>
        public static ConversationActions ConversationActions(int completed = default, int failed = default, int inProgress = default, int total = default, IEnumerable<AnalyzeConversationOperationResult> items = null)
        {
            items ??= new List<AnalyzeConversationOperationResult>();

            return new ConversationActions(
                completed,
                failed,
                inProgress,
                total,
                items?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalyzeConversationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> discriminator kind. </param>
        /// <returns> A new <see cref="Models.AnalyzeConversationOperationResult"/> instance for mocking. </returns>
        public static AnalyzeConversationOperationResult AnalyzeConversationOperationResult(DateTimeOffset lastUpdateDateTime = default, ConversationActionState status = default, string name = null, string kind = null)
        {
            return new UnknownAnalyzeConversationOperationResult(lastUpdateDateTime, status, name, kind == null ? default : new AnalyzeConversationOperationResultsKind(kind), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationPiiOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="results"> results. </param>
        /// <returns> A new <see cref="Models.ConversationPiiOperationResult"/> instance for mocking. </returns>
        public static ConversationPiiOperationResult ConversationPiiOperationResult(DateTimeOffset lastUpdateDateTime = default, ConversationActionState status = default, string name = null, ConversationPiiResults results = null)
        {
            return new ConversationPiiOperationResult(
                lastUpdateDateTime,
                status,
                name,
                AnalyzeConversationOperationResultsKind.PiiOperationResults,
                serializedAdditionalRawData: null,
                results);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationPiiResults"/>. </summary>
        /// <param name="errors"> Errors by document id. </param>
        /// <param name="statistics"> statistics. </param>
        /// <param name="modelVersion"> This field indicates which model is used for scoring. </param>
        /// <param name="conversations"> array of conversations. </param>
        /// <returns> A new <see cref="Models.ConversationPiiResults"/> instance for mocking. </returns>
        public static ConversationPiiResults ConversationPiiResults(IEnumerable<DocumentError> errors = null, RequestStatistics statistics = null, string modelVersion = null, IEnumerable<ConversationalPiiResult> conversations = null)
        {
            errors ??= new List<DocumentError>();
            conversations ??= new List<ConversationalPiiResult>();

            return new ConversationPiiResults(errors?.ToList(), statistics, modelVersion, conversations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DocumentError"/>. </summary>
        /// <param name="id"> The ID of the input document. </param>
        /// <param name="error"> Error encountered. </param>
        /// <returns> A new <see cref="Models.DocumentError"/> instance for mocking. </returns>
        public static DocumentError DocumentError(string id = null, ConversationError error = null)
        {
            return new DocumentError(id, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RequestStatistics"/>. </summary>
        /// <param name="documentsCount"> Number of documents submitted in the request. </param>
        /// <param name="validDocumentsCount"> Number of valid documents. This excludes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="erroneousDocumentsCount"> Number of invalid documents. This includes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="transactionsCount"> Number of transactions for the request. </param>
        /// <returns> A new <see cref="Models.RequestStatistics"/> instance for mocking. </returns>
        public static RequestStatistics RequestStatistics(int documentsCount = default, int validDocumentsCount = default, int erroneousDocumentsCount = default, long transactionsCount = default)
        {
            return new RequestStatistics(documentsCount, validDocumentsCount, erroneousDocumentsCount, transactionsCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationalPiiResult"/>. </summary>
        /// <param name="id"> Unique, non-empty conversation identifier. </param>
        /// <param name="warnings"> Warnings encountered in processing the document. </param>
        /// <param name="statistics"> If showStats=true was specified in the request this field will contain information about the conversation payload. </param>
        /// <param name="conversationItems"> List of conversationItems. </param>
        /// <returns> A new <see cref="Models.ConversationalPiiResult"/> instance for mocking. </returns>
        public static ConversationalPiiResult ConversationalPiiResult(string id = null, IEnumerable<InputWarning> warnings = null, ConversationStatistics statistics = null, IEnumerable<ConversationPiiItemResult> conversationItems = null)
        {
            warnings ??= new List<InputWarning>();
            conversationItems ??= new List<ConversationPiiItemResult>();

            return new ConversationalPiiResult(id, warnings?.ToList(), statistics, conversationItems?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InputWarning"/>. </summary>
        /// <param name="code"> Warning code. </param>
        /// <param name="message"> Warning message. </param>
        /// <param name="targetRef"> A JSON pointer reference indicating the target object. </param>
        /// <returns> A new <see cref="Models.InputWarning"/> instance for mocking. </returns>
        public static InputWarning InputWarning(string code = null, string message = null, string targetRef = null)
        {
            return new InputWarning(code, message, targetRef, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationStatistics"/>. </summary>
        /// <param name="transactionsCount"> Number of text units for the request. </param>
        /// <returns> A new <see cref="Models.ConversationStatistics"/> instance for mocking. </returns>
        public static ConversationStatistics ConversationStatistics(int transactionsCount = default)
        {
            return new ConversationStatistics(transactionsCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationPiiItemResult"/>. </summary>
        /// <param name="id"> Id of the result. </param>
        /// <param name="redactedContent"> Transcript content response that the service generates, with all necessary personally identifiable information redacted. </param>
        /// <param name="entities"> Array of Entities. </param>
        /// <returns> A new <see cref="Models.ConversationPiiItemResult"/> instance for mocking. </returns>
        public static ConversationPiiItemResult ConversationPiiItemResult(string id = null, RedactedTranscriptContent redactedContent = null, IEnumerable<NamedEntity> entities = null)
        {
            entities ??= new List<NamedEntity>();

            return new ConversationPiiItemResult(id, redactedContent, entities?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RedactedTranscriptContent"/>. </summary>
        /// <param name="inverseTextNormalized"> Redacted output for input in inverse-text-normalized format. </param>
        /// <param name="maskedInverseTextNormalized"> Redacted output for input in masked inverse-text-normalized format. </param>
        /// <param name="text"> Redacted output for input in text (Microsoft's speech-to-text 'display') format. </param>
        /// <param name="lexical"> Redacted output for input in lexical format. </param>
        /// <param name="audioTimings"> List of redacted audio segments. </param>
        /// <returns> A new <see cref="Models.RedactedTranscriptContent"/> instance for mocking. </returns>
        public static RedactedTranscriptContent RedactedTranscriptContent(string inverseTextNormalized = null, string maskedInverseTextNormalized = null, string text = null, string lexical = null, IEnumerable<AudioTiming> audioTimings = null)
        {
            audioTimings ??= new List<AudioTiming>();

            return new RedactedTranscriptContent(
                inverseTextNormalized,
                maskedInverseTextNormalized,
                text,
                lexical,
                audioTimings?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AudioTiming"/>. </summary>
        /// <param name="offset"> Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds. </param>
        /// <param name="duration"> Duration of word articulation, in ticks. 1 tick = 100 nanoseconds. </param>
        /// <returns> A new <see cref="Models.AudioTiming"/> instance for mocking. </returns>
        public static AudioTiming AudioTiming(long? offset = null, long? duration = null)
        {
            return new AudioTiming(offset, duration, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NamedEntity"/>. </summary>
        /// <param name="text"> Entity text as appears in the request. </param>
        /// <param name="category"> Entity type. </param>
        /// <param name="subcategory"> (Optional) Entity sub type. </param>
        /// <param name="offset"> Start position for the entity text. Use of different 'stringIndexType' values can affect the offset returned. </param>
        /// <param name="length"> Length for the entity text. Use of different 'stringIndexType' values can affect the length returned. </param>
        /// <param name="confidenceScore"> Confidence score between 0 and 1 of the extracted entity. </param>
        /// <returns> A new <see cref="Models.NamedEntity"/> instance for mocking. </returns>
        public static NamedEntity NamedEntity(string text = null, string category = null, string subcategory = null, int offset = default, int length = default, double confidenceScore = default)
        {
            return new NamedEntity(
                text,
                category,
                subcategory,
                offset,
                length,
                confidenceScore,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SummarizationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="results"> results. </param>
        /// <returns> A new <see cref="Models.SummarizationOperationResult"/> instance for mocking. </returns>
        public static SummarizationOperationResult SummarizationOperationResult(DateTimeOffset lastUpdateDateTime = default, ConversationActionState status = default, string name = null, SummaryResult results = null)
        {
            return new SummarizationOperationResult(
                lastUpdateDateTime,
                status,
                name,
                AnalyzeConversationOperationResultsKind.SummarizationOperationResults,
                serializedAdditionalRawData: null,
                results);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SummaryResult"/>. </summary>
        /// <param name="conversations"> array of conversations. </param>
        /// <param name="errors"> Errors by document id. </param>
        /// <param name="statistics"> statistics. </param>
        /// <param name="modelVersion"> This field indicates which model is used for scoring. </param>
        /// <returns> A new <see cref="Models.SummaryResult"/> instance for mocking. </returns>
        public static SummaryResult SummaryResult(IEnumerable<ConversationsSummaryResult> conversations = null, IEnumerable<DocumentError> errors = null, RequestStatistics statistics = null, string modelVersion = null)
        {
            conversations ??= new List<ConversationsSummaryResult>();
            errors ??= new List<DocumentError>();

            return new SummaryResult(conversations?.ToList(), errors?.ToList(), statistics, modelVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationsSummaryResult"/>. </summary>
        /// <param name="id"> Unique, non-empty conversation identifier. </param>
        /// <param name="warnings"> Warnings encountered in processing the document. </param>
        /// <param name="statistics"> If showStats=true was specified in the request this field will contain information about the conversation payload. </param>
        /// <param name="summaries"> array of summaries. </param>
        /// <returns> A new <see cref="Models.ConversationsSummaryResult"/> instance for mocking. </returns>
        public static ConversationsSummaryResult ConversationsSummaryResult(string id = null, IEnumerable<InputWarning> warnings = null, ConversationStatistics statistics = null, IEnumerable<SummaryResultItem> summaries = null)
        {
            warnings ??= new List<InputWarning>();
            summaries ??= new List<SummaryResultItem>();

            return new ConversationsSummaryResult(id, warnings?.ToList(), statistics, summaries?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SummaryResultItem"/>. </summary>
        /// <param name="aspect"> aspect. </param>
        /// <param name="text"> text. </param>
        /// <param name="contexts"> Context list of the summary. </param>
        /// <returns> A new <see cref="Models.SummaryResultItem"/> instance for mocking. </returns>
        public static SummaryResultItem SummaryResultItem(string aspect = null, string text = null, IEnumerable<ItemizedSummaryContext> contexts = null)
        {
            contexts ??= new List<ItemizedSummaryContext>();

            return new SummaryResultItem(aspect, text, contexts?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ItemizedSummaryContext"/>. </summary>
        /// <param name="offset"> Start position for the context. Use of different 'stringIndexType' values can affect the offset returned. </param>
        /// <param name="length"> The length of the context. Use of different 'stringIndexType' values can affect the length returned. </param>
        /// <param name="conversationItemId"> Reference to the ID of ConversationItem. </param>
        /// <returns> A new <see cref="Models.ItemizedSummaryContext"/> instance for mocking. </returns>
        public static ItemizedSummaryContext ItemizedSummaryContext(int offset = default, int length = default, string conversationItemId = null)
        {
            return new ItemizedSummaryContext(offset, length, conversationItemId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomSummarizationOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="results"> Custom Summary Result. </param>
        /// <returns> A new <see cref="Models.CustomSummarizationOperationResult"/> instance for mocking. </returns>
        public static CustomSummarizationOperationResult CustomSummarizationOperationResult(DateTimeOffset lastUpdateDateTime = default, ConversationActionState status = default, string name = null, CustomSummaryResult results = null)
        {
            return new CustomSummarizationOperationResult(
                lastUpdateDateTime,
                status,
                name,
                AnalyzeConversationOperationResultsKind.CustomSummarizationOperationResults,
                serializedAdditionalRawData: null,
                results);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomSummaryResult"/>. </summary>
        /// <param name="conversations"> array of conversations. </param>
        /// <param name="errors"> Errors by document id. </param>
        /// <param name="statistics"> if showStats=true was specified in the request this field will contain information about the request payload. </param>
        /// <param name="projectName"> This field indicates the project name for the model. </param>
        /// <param name="deploymentName"> This field indicates the deployment name for the model. </param>
        /// <returns> A new <see cref="Models.CustomSummaryResult"/> instance for mocking. </returns>
        public static CustomSummaryResult CustomSummaryResult(IEnumerable<ConversationsSummaryResult> conversations = null, IEnumerable<DocumentError> errors = null, RequestStatistics statistics = null, string projectName = null, string deploymentName = null)
        {
            conversations ??= new List<ConversationsSummaryResult>();
            errors ??= new List<DocumentError>();

            return new CustomSummaryResult(
                conversations?.ToList(),
                errors?.ToList(),
                statistics,
                projectName,
                deploymentName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationRequestStatistics"/>. </summary>
        /// <param name="documentsCount"> Number of documents submitted in the request. </param>
        /// <param name="validDocumentsCount"> Number of valid documents. This excludes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="erroneousDocumentsCount"> Number of invalid documents. This includes empty, over-size limit or non-supported languages documents. </param>
        /// <param name="transactionsCount"> Number of transactions for the request. </param>
        /// <param name="conversationsCount"> Number of conversations submitted in the request. </param>
        /// <param name="validConversationsCount"> Number of conversation documents. This excludes documents that are empty, over the size limit, or in unsupported languages. </param>
        /// <param name="erroneousConversationsCount"> Number of invalid documents. This includes documents that are empty, over the size limit, or in unsupported languages. </param>
        /// <returns> A new <see cref="Models.ConversationRequestStatistics"/> instance for mocking. </returns>
        public static ConversationRequestStatistics ConversationRequestStatistics(int documentsCount = default, int validDocumentsCount = default, int erroneousDocumentsCount = default, long transactionsCount = default, int conversationsCount = default, int validConversationsCount = default, int erroneousConversationsCount = default)
        {
            return new ConversationRequestStatistics(
                documentsCount,
                validDocumentsCount,
                erroneousDocumentsCount,
                transactionsCount,
                conversationsCount,
                validConversationsCount,
                erroneousConversationsCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalyzeConversationOperationInput"/>. </summary>
        /// <param name="displayName"> Display name for the analysis job. </param>
        /// <param name="conversationInput"> Analysis Input. </param>
        /// <param name="actions">
        /// Set of tasks to execute on the input conversation.
        /// Please note <see cref="AnalyzeConversationOperationAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="PiiOperationAction"/>, <see cref="SummarizationOperationAction"/> and <see cref="CustomSummarizationOperationAction"/>.
        /// </param>
        /// <returns> A new <see cref="Models.AnalyzeConversationOperationInput"/> instance for mocking. </returns>
        public static AnalyzeConversationOperationInput AnalyzeConversationOperationInput(string displayName = null, MultiLanguageConversationInput conversationInput = null, IEnumerable<AnalyzeConversationOperationAction> actions = null)
        {
            actions ??= new List<AnalyzeConversationOperationAction>();

            return new AnalyzeConversationOperationInput(displayName, conversationInput, actions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConversationInput"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="modality"> modality. </param>
        /// <param name="domain"> domain. </param>
        /// <returns> A new <see cref="Models.ConversationInput"/> instance for mocking. </returns>
        public static ConversationInput ConversationInput(string id = null, string language = null, string modality = null, ConversationDomain? domain = null)
        {
            return new UnknownConversationInput(id, language, modality == null ? default : new InputModality(modality), domain, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TextConversation"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="domain"> domain. </param>
        /// <param name="conversationItems"> Ordered list of text conversation items in the conversation. </param>
        /// <returns> A new <see cref="Models.TextConversation"/> instance for mocking. </returns>
        public static TextConversation TextConversation(string id = null, string language = null, ConversationDomain? domain = null, IEnumerable<TextConversationItem> conversationItems = null)
        {
            conversationItems ??= new List<TextConversationItem>();

            return new TextConversation(
                id,
                language,
                InputModality.Text,
                domain,
                serializedAdditionalRawData: null,
                conversationItems?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.TranscriptConversation"/>. </summary>
        /// <param name="id"> Unique identifier for the conversation. </param>
        /// <param name="language"> Language of the conversation item in BCP-47 format. </param>
        /// <param name="domain"> domain. </param>
        /// <param name="conversationItems"> Ordered list of transcript conversation items in the conversation. </param>
        /// <returns> A new <see cref="Models.TranscriptConversation"/> instance for mocking. </returns>
        public static TranscriptConversation TranscriptConversation(string id = null, string language = null, ConversationDomain? domain = null, IEnumerable<TranscriptConversationItem> conversationItems = null)
        {
            conversationItems ??= new List<TranscriptConversationItem>();

            return new TranscriptConversation(
                id,
                language,
                InputModality.Transcript,
                domain,
                serializedAdditionalRawData: null,
                conversationItems?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.TranscriptConversationItem"/>. </summary>
        /// <param name="id"> The ID of a conversation item. </param>
        /// <param name="participantId"> The participant ID of a conversation item. </param>
        /// <param name="language"> The override language of a conversation item in BCP 47 language representation. </param>
        /// <param name="modality"> Enumeration of supported conversational modalities. </param>
        /// <param name="role"> Role of the participant. </param>
        /// <param name="inverseTextNormalized"> Inverse text normalization (ITN) representation of input. The inverse-text-normalized form is the recognized text from Microsoft's speech-to-text API, with phone numbers, numbers, abbreviations, and other transformations applied. </param>
        /// <param name="maskedInverseTextNormalized"> Inverse-text-normalized format with profanity masking applied. </param>
        /// <param name="text"> Display form of the recognized text from the speech-to-text API, with punctuation and capitalization added. </param>
        /// <param name="lexical"> Lexical form of the recognized text from the speech-to-text API, with the actual words recognized. </param>
        /// <param name="wordLevelTimings"> List of word-level audio timing information. </param>
        /// <param name="conversationItemLevelTiming"> Audio timing at the conversation item level. This still can help with AI quality if word-level audio timings are not available. </param>
        /// <returns> A new <see cref="Models.TranscriptConversationItem"/> instance for mocking. </returns>
        public static TranscriptConversationItem TranscriptConversationItem(string id = null, string participantId = null, string language = null, InputModality? modality = null, ParticipantRole? role = null, string inverseTextNormalized = null, string maskedInverseTextNormalized = null, string text = null, string lexical = null, IEnumerable<WordLevelTiming> wordLevelTimings = null, ConversationItemLevelTiming conversationItemLevelTiming = null)
        {
            wordLevelTimings ??= new List<WordLevelTiming>();

            return new TranscriptConversationItem(
                id,
                participantId,
                language,
                modality,
                role,
                inverseTextNormalized,
                maskedInverseTextNormalized,
                text,
                lexical,
                wordLevelTimings?.ToList(),
                conversationItemLevelTiming,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomConversationSummarizationActionContent"/>. </summary>
        /// <param name="loggingOptOut"> logging opt out. </param>
        /// <param name="projectName"> This field indicates the project name for the model. </param>
        /// <param name="deploymentName"> This field indicates the deployment name for the model. </param>
        /// <param name="sentenceCount"> It controls the approximate number of sentences in the output summaries. </param>
        /// <param name="stringIndexType"> String index type. </param>
        /// <param name="summaryLength"> Controls the approximate length of the output summaries. Recommended to use summaryLength over sentenceCount. </param>
        /// <param name="summaryAspects"> Array of Summary Aspects. </param>
        /// <returns> A new <see cref="Models.CustomConversationSummarizationActionContent"/> instance for mocking. </returns>
        public static CustomConversationSummarizationActionContent CustomConversationSummarizationActionContent(bool? loggingOptOut = null, string projectName = null, string deploymentName = null, int? sentenceCount = null, StringIndexType? stringIndexType = null, SummaryLengthBucket? summaryLength = null, IEnumerable<SummaryAspect> summaryAspects = null)
        {
            summaryAspects ??= new List<SummaryAspect>();

            return new CustomConversationSummarizationActionContent(
                loggingOptOut,
                projectName,
                deploymentName,
                sentenceCount,
                stringIndexType,
                summaryLength,
                summaryAspects?.ToList(),
                serializedAdditionalRawData: null);
        }
    }
}
