// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure;
using Azure.AI.Language.Conversations;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="ConversationAnalysisClient"/> to client builder. </summary>
    public static partial class ConversationAnalysisClientExtensions
    {
        /// <summary> Registers a <see cref="ConversationAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoint (e.g., https://&lt;resource-name&gt;.api.cognitiveservices.azure.com). </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<ConversationAnalysisClient, ConversationsClientOptions> AddConversationAnalysisClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<ConversationAnalysisClient, ConversationsClientOptions>((options) => new ConversationAnalysisClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="ConversationAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoint (e.g., https://&lt;resource-name&gt;.api.cognitiveservices.azure.com). </param>
        public static IAzureClientBuilder<ConversationAnalysisClient, ConversationsClientOptions> AddConversationAnalysisClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<ConversationAnalysisClient, ConversationsClientOptions>((options, cred) => new ConversationAnalysisClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="ConversationAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<ConversationAnalysisClient, ConversationsClientOptions> AddConversationAnalysisClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<ConversationAnalysisClient, ConversationsClientOptions>(configuration);
        }
    }
}
