// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Enum of the selector type. </summary>
    internal readonly partial struct SelectorType : IEquatable<SelectorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SelectorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SelectorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ListValue = "List";
        private const string QueryValue = "Query";

        /// <summary> List. </summary>
        public static SelectorType List { get; } = new SelectorType(ListValue);
        /// <summary> Query. </summary>
        public static SelectorType Query { get; } = new SelectorType(QueryValue);
        /// <summary> Determines if two <see cref="SelectorType"/> values are the same. </summary>
        public static bool operator ==(SelectorType left, SelectorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SelectorType"/> values are not the same. </summary>
        public static bool operator !=(SelectorType left, SelectorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SelectorType"/>. </summary>
        public static implicit operator SelectorType(string value) => new SelectorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SelectorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SelectorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
