// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Model that represents a simple target filter. </summary>
    public partial class ChaosTargetSimpleFilter : ChaosTargetFilter
    {
        /// <summary> Initializes a new instance of <see cref="ChaosTargetSimpleFilter"/>. </summary>
        public ChaosTargetSimpleFilter()
        {
            FilterType = FilterType.Simple;
        }

        /// <summary> Initializes a new instance of <see cref="ChaosTargetSimpleFilter"/>. </summary>
        /// <param name="filterType"> Enum that discriminates between filter types. Currently only `Simple` type is supported. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="parameters"> Model that represents the Simple filter parameters. </param>
        internal ChaosTargetSimpleFilter(FilterType filterType, IDictionary<string, BinaryData> serializedAdditionalRawData, ChaosTargetSimpleFilterParameters parameters) : base(filterType, serializedAdditionalRawData)
        {
            Parameters = parameters;
            FilterType = filterType;
        }

        /// <summary> Model that represents the Simple filter parameters. </summary>
        internal ChaosTargetSimpleFilterParameters Parameters { get; set; }
        /// <summary> List of Azure availability zones to filter targets by. </summary>
        public IList<string> ParametersZones
        {
            get
            {
                if (Parameters is null)
                    Parameters = new ChaosTargetSimpleFilterParameters();
                return Parameters.Zones;
            }
        }
    }
}
