// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Enum of the Target reference type. </summary>
    public readonly partial struct ChaosTargetReferenceType : IEquatable<ChaosTargetReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChaosTargetReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChaosTargetReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ChaosTargetValue = "ChaosTarget";

        /// <summary> ChaosTarget. </summary>
        public static ChaosTargetReferenceType ChaosTarget { get; } = new ChaosTargetReferenceType(ChaosTargetValue);
        /// <summary> Determines if two <see cref="ChaosTargetReferenceType"/> values are the same. </summary>
        public static bool operator ==(ChaosTargetReferenceType left, ChaosTargetReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChaosTargetReferenceType"/> values are not the same. </summary>
        public static bool operator !=(ChaosTargetReferenceType left, ChaosTargetReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChaosTargetReferenceType"/>. </summary>
        public static implicit operator ChaosTargetReferenceType(string value) => new ChaosTargetReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChaosTargetReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChaosTargetReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
