// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Current provisioning state for a given Azure Chaos resource. </summary>
    public readonly partial struct ChaosProvisioningState : IEquatable<ChaosProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChaosProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChaosProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Succeeded. </summary>
        public static ChaosProvisioningState Succeeded { get; } = new ChaosProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ChaosProvisioningState Failed { get; } = new ChaosProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ChaosProvisioningState Canceled { get; } = new ChaosProvisioningState(CanceledValue);
        /// <summary> Creating. </summary>
        public static ChaosProvisioningState Creating { get; } = new ChaosProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ChaosProvisioningState Updating { get; } = new ChaosProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ChaosProvisioningState Deleting { get; } = new ChaosProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="ChaosProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ChaosProvisioningState left, ChaosProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChaosProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ChaosProvisioningState left, ChaosProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChaosProvisioningState"/>. </summary>
        public static implicit operator ChaosProvisioningState(string value) => new ChaosProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChaosProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChaosProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
