// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Model that represents a step in the Experiment resource. </summary>
    public partial class ChaosExperimentStep
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChaosExperimentStep"/>. </summary>
        /// <param name="name"> String of the step name. </param>
        /// <param name="branches"> List of branches. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="branches"/> is null. </exception>
        public ChaosExperimentStep(string name, IEnumerable<ChaosExperimentBranch> branches)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(branches, nameof(branches));

            Name = name;
            Branches = branches.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ChaosExperimentStep"/>. </summary>
        /// <param name="name"> String of the step name. </param>
        /// <param name="branches"> List of branches. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChaosExperimentStep(string name, IList<ChaosExperimentBranch> branches, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Branches = branches;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChaosExperimentStep"/> for deserialization. </summary>
        internal ChaosExperimentStep()
        {
        }

        /// <summary> String of the step name. </summary>
        public string Name { get; set; }
        /// <summary> List of branches. </summary>
        public IList<ChaosExperimentBranch> Branches { get; }
    }
}
