// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Chaos.Models
{
    /// <summary> Model that represents the a list of actions and action statuses. </summary>
    public partial class ChaosExperimentRunBranchStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChaosExperimentRunBranchStatus"/>. </summary>
        internal ChaosExperimentRunBranchStatus()
        {
            Actions = new ChangeTrackingList<ChaosExperimentRunActionStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="ChaosExperimentRunBranchStatus"/>. </summary>
        /// <param name="branchName"> The name of the branch status. </param>
        /// <param name="branchId"> The id of the branch status. </param>
        /// <param name="status"> The status of the branch. </param>
        /// <param name="actions"> The array of actions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChaosExperimentRunBranchStatus(string branchName, string branchId, string status, IReadOnlyList<ChaosExperimentRunActionStatus> actions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BranchName = branchName;
            BranchId = branchId;
            Status = status;
            Actions = actions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the branch status. </summary>
        public string BranchName { get; }
        /// <summary> The id of the branch status. </summary>
        public string BranchId { get; }
        /// <summary> The status of the branch. </summary>
        public string Status { get; }
        /// <summary> The array of actions. </summary>
        public IReadOnlyList<ChaosExperimentRunActionStatus> Actions { get; }
    }
}
