// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Chaos
{
    internal class ChaosExperimentOperationSource : IOperationSource<ChaosExperimentResource>
    {
        private readonly ArmClient _client;

        internal ChaosExperimentOperationSource(ArmClient client)
        {
            _client = client;
        }

        ChaosExperimentResource IOperationSource<ChaosExperimentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ChaosExperimentData.DeserializeChaosExperimentData(document.RootElement);
            return new ChaosExperimentResource(_client, data);
        }

        async ValueTask<ChaosExperimentResource> IOperationSource<ChaosExperimentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ChaosExperimentData.DeserializeChaosExperimentData(document.RootElement);
            return new ChaosExperimentResource(_client, data);
        }
    }
}
