// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Chaos.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableChaosArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableChaosArmClient"/> class for mocking. </summary>
        protected MockableChaosArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableChaosArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableChaosArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableChaosArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosCapabilityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosCapabilityResource.CreateResourceIdentifier" /> to create a <see cref="ChaosCapabilityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosCapabilityResource"/> object. </returns>
        public virtual ChaosCapabilityResource GetChaosCapabilityResource(ResourceIdentifier id)
        {
            ChaosCapabilityResource.ValidateResourceId(id);
            return new ChaosCapabilityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosCapabilityTypeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosCapabilityTypeResource.CreateResourceIdentifier" /> to create a <see cref="ChaosCapabilityTypeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosCapabilityTypeResource"/> object. </returns>
        public virtual ChaosCapabilityTypeResource GetChaosCapabilityTypeResource(ResourceIdentifier id)
        {
            ChaosCapabilityTypeResource.ValidateResourceId(id);
            return new ChaosCapabilityTypeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosExperimentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosExperimentResource.CreateResourceIdentifier" /> to create a <see cref="ChaosExperimentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosExperimentResource"/> object. </returns>
        public virtual ChaosExperimentResource GetChaosExperimentResource(ResourceIdentifier id)
        {
            ChaosExperimentResource.ValidateResourceId(id);
            return new ChaosExperimentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosExperimentExecutionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosExperimentExecutionResource.CreateResourceIdentifier" /> to create a <see cref="ChaosExperimentExecutionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosExperimentExecutionResource"/> object. </returns>
        public virtual ChaosExperimentExecutionResource GetChaosExperimentExecutionResource(ResourceIdentifier id)
        {
            ChaosExperimentExecutionResource.ValidateResourceId(id);
            return new ChaosExperimentExecutionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosTargetTypeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosTargetTypeResource.CreateResourceIdentifier" /> to create a <see cref="ChaosTargetTypeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosTargetTypeResource"/> object. </returns>
        public virtual ChaosTargetTypeResource GetChaosTargetTypeResource(ResourceIdentifier id)
        {
            ChaosTargetTypeResource.ValidateResourceId(id);
            return new ChaosTargetTypeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ChaosTargetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ChaosTargetResource.CreateResourceIdentifier" /> to create a <see cref="ChaosTargetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ChaosTargetResource"/> object. </returns>
        public virtual ChaosTargetResource GetChaosTargetResource(ResourceIdentifier id)
        {
            ChaosTargetResource.ValidateResourceId(id);
            return new ChaosTargetResource(Client, id);
        }
    }
}
