// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Chaos.Samples
{
    public partial class Sample_ChaosTargetResource
    {
        // Get a Target that extends a virtual machine resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetATargetThatExtendsAVirtualMachineResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/GetTarget.json
            // this example is just showing the usage of "Targets_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetResource created on azure
            // for more information of creating ChaosTargetResource, please refer to the document of ChaosTargetResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-Agent";
            ResourceIdentifier chaosTargetResourceId = ChaosTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
            ChaosTargetResource chaosTarget = client.GetChaosTargetResource(chaosTargetResourceId);

            // invoke the operation
            ChaosTargetResource result = await chaosTarget.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ChaosTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a Target that extends a virtual machine resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteATargetThatExtendsAVirtualMachineResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/DeleteTarget.json
            // this example is just showing the usage of "Targets_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetResource created on azure
            // for more information of creating ChaosTargetResource, please refer to the document of ChaosTargetResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-Agent";
            ResourceIdentifier chaosTargetResourceId = ChaosTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
            ChaosTargetResource chaosTarget = client.GetChaosTargetResource(chaosTargetResourceId);

            // invoke the operation
            await chaosTarget.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Create/update a Target that extends a virtual machine resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateATargetThatExtendsAVirtualMachineResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/CreateUpdateTarget.json
            // this example is just showing the usage of "Targets_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetResource created on azure
            // for more information of creating ChaosTargetResource, please refer to the document of ChaosTargetResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-Agent";
            ResourceIdentifier chaosTargetResourceId = ChaosTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName);
            ChaosTargetResource chaosTarget = client.GetChaosTargetResource(chaosTargetResourceId);

            // invoke the operation
            ChaosTargetData data = new ChaosTargetData(new Dictionary<string, BinaryData>()
            {
                ["identities"] = BinaryData.FromObjectAsJson(new object[] { new Dictionary<string, object>()
{
["type"] = "CertificateSubjectIssuer",
["subject"] = "CN=example.subject"} }),
            });
            ArmOperation<ChaosTargetResource> lro = await chaosTarget.UpdateAsync(WaitUntil.Completed, data);
            ChaosTargetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ChaosTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
