// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Chaos.Samples
{
    public partial class Sample_ChaosCapabilityTypeCollection
    {
        // List all Capability Types for a virtual machine Target resource on westus2 location.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListAllCapabilityTypesForAVirtualMachineTargetResourceOnWestus2Location()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/ListCapabilityTypes.json
            // this example is just showing the usage of "CapabilityTypes_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetTypeResource created on azure
            // for more information of creating ChaosTargetTypeResource, please refer to the document of ChaosTargetTypeResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string locationName = "westus2";
            string targetTypeName = "Microsoft-VirtualMachine";
            ResourceIdentifier chaosTargetTypeResourceId = ChaosTargetTypeResource.CreateResourceIdentifier(subscriptionId, locationName, targetTypeName);
            ChaosTargetTypeResource chaosTargetType = client.GetChaosTargetTypeResource(chaosTargetTypeResourceId);

            // get the collection of this ChaosCapabilityTypeResource
            ChaosCapabilityTypeCollection collection = chaosTargetType.GetChaosCapabilityTypes();

            // invoke the operation and iterate over the result
            await foreach (ChaosCapabilityTypeResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ChaosCapabilityTypeData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a Capability Type for a virtual machine Target resource on westus2 location.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetACapabilityTypeForAVirtualMachineTargetResourceOnWestus2Location()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/GetCapabilityType.json
            // this example is just showing the usage of "CapabilityTypes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetTypeResource created on azure
            // for more information of creating ChaosTargetTypeResource, please refer to the document of ChaosTargetTypeResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string locationName = "westus2";
            string targetTypeName = "Microsoft-VirtualMachine";
            ResourceIdentifier chaosTargetTypeResourceId = ChaosTargetTypeResource.CreateResourceIdentifier(subscriptionId, locationName, targetTypeName);
            ChaosTargetTypeResource chaosTargetType = client.GetChaosTargetTypeResource(chaosTargetTypeResourceId);

            // get the collection of this ChaosCapabilityTypeResource
            ChaosCapabilityTypeCollection collection = chaosTargetType.GetChaosCapabilityTypes();

            // invoke the operation
            string capabilityTypeName = "Shutdown-1.0";
            ChaosCapabilityTypeResource result = await collection.GetAsync(capabilityTypeName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ChaosCapabilityTypeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a Capability Type for a virtual machine Target resource on westus2 location.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetACapabilityTypeForAVirtualMachineTargetResourceOnWestus2Location()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/GetCapabilityType.json
            // this example is just showing the usage of "CapabilityTypes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetTypeResource created on azure
            // for more information of creating ChaosTargetTypeResource, please refer to the document of ChaosTargetTypeResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string locationName = "westus2";
            string targetTypeName = "Microsoft-VirtualMachine";
            ResourceIdentifier chaosTargetTypeResourceId = ChaosTargetTypeResource.CreateResourceIdentifier(subscriptionId, locationName, targetTypeName);
            ChaosTargetTypeResource chaosTargetType = client.GetChaosTargetTypeResource(chaosTargetTypeResourceId);

            // get the collection of this ChaosCapabilityTypeResource
            ChaosCapabilityTypeCollection collection = chaosTargetType.GetChaosCapabilityTypes();

            // invoke the operation
            string capabilityTypeName = "Shutdown-1.0";
            bool result = await collection.ExistsAsync(capabilityTypeName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a Capability Type for a virtual machine Target resource on westus2 location.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetACapabilityTypeForAVirtualMachineTargetResourceOnWestus2Location()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/GetCapabilityType.json
            // this example is just showing the usage of "CapabilityTypes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosTargetTypeResource created on azure
            // for more information of creating ChaosTargetTypeResource, please refer to the document of ChaosTargetTypeResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string locationName = "westus2";
            string targetTypeName = "Microsoft-VirtualMachine";
            ResourceIdentifier chaosTargetTypeResourceId = ChaosTargetTypeResource.CreateResourceIdentifier(subscriptionId, locationName, targetTypeName);
            ChaosTargetTypeResource chaosTargetType = client.GetChaosTargetTypeResource(chaosTargetTypeResourceId);

            // get the collection of this ChaosCapabilityTypeResource
            ChaosCapabilityTypeCollection collection = chaosTargetType.GetChaosCapabilityTypes();

            // invoke the operation
            string capabilityTypeName = "Shutdown-1.0";
            NullableResponse<ChaosCapabilityTypeResource> response = await collection.GetIfExistsAsync(capabilityTypeName);
            ChaosCapabilityTypeResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ChaosCapabilityTypeData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
