// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Chaos.Samples
{
    public partial class Sample_ChaosCapabilityResource
    {
        // Get a Capability that extends a virtual machine Target resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetACapabilityThatExtendsAVirtualMachineTargetResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/GetCapability.json
            // this example is just showing the usage of "Capabilities_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosCapabilityResource created on azure
            // for more information of creating ChaosCapabilityResource, please refer to the document of ChaosCapabilityResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-VirtualMachine";
            string capabilityName = "Shutdown-1.0";
            ResourceIdentifier chaosCapabilityResourceId = ChaosCapabilityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName);
            ChaosCapabilityResource chaosCapability = client.GetChaosCapabilityResource(chaosCapabilityResourceId);

            // invoke the operation
            ChaosCapabilityResource result = await chaosCapability.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ChaosCapabilityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a Capability that extends a virtual machine Target resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteACapabilityThatExtendsAVirtualMachineTargetResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/DeleteCapability.json
            // this example is just showing the usage of "Capabilities_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosCapabilityResource created on azure
            // for more information of creating ChaosCapabilityResource, please refer to the document of ChaosCapabilityResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-VirtualMachine";
            string capabilityName = "Shutdown-1.0";
            ResourceIdentifier chaosCapabilityResourceId = ChaosCapabilityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName);
            ChaosCapabilityResource chaosCapability = client.GetChaosCapabilityResource(chaosCapabilityResourceId);

            // invoke the operation
            await chaosCapability.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Create/update a Capability that extends a virtual machine Target resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateACapabilityThatExtendsAVirtualMachineTargetResource()
        {
            // Generated from example definition: specification/chaos/resource-manager/Microsoft.Chaos/stable/2024-01-01/examples/CreateUpdateCapability.json
            // this example is just showing the usage of "Capabilities_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ChaosCapabilityResource created on azure
            // for more information of creating ChaosCapabilityResource, please refer to the document of ChaosCapabilityResource
            string subscriptionId = "6b052e15-03d3-4f17-b2e1-be7f07588291";
            string resourceGroupName = "exampleRG";
            string parentProviderNamespace = "Microsoft.Compute";
            string parentResourceType = "virtualMachines";
            string parentResourceName = "exampleVM";
            string targetName = "Microsoft-VirtualMachine";
            string capabilityName = "Shutdown-1.0";
            ResourceIdentifier chaosCapabilityResourceId = ChaosCapabilityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, parentProviderNamespace, parentResourceType, parentResourceName, targetName, capabilityName);
            ChaosCapabilityResource chaosCapability = client.GetChaosCapabilityResource(chaosCapabilityResourceId);

            // invoke the operation
            ChaosCapabilityData data = new ChaosCapabilityData();
            ArmOperation<ChaosCapabilityResource> lro = await chaosCapability.UpdateAsync(WaitUntil.Completed, data);
            ChaosCapabilityResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ChaosCapabilityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
