// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ChangeAnalysis.Models
{
    /// <summary> The PropertyChangeLevel. </summary>
    public readonly partial struct PropertyChangeLevel : IEquatable<PropertyChangeLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PropertyChangeLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PropertyChangeLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoisyValue = "Noisy";
        private const string NormalValue = "Normal";
        private const string ImportantValue = "Important";

        /// <summary> Noisy. </summary>
        public static PropertyChangeLevel Noisy { get; } = new PropertyChangeLevel(NoisyValue);
        /// <summary> Normal. </summary>
        public static PropertyChangeLevel Normal { get; } = new PropertyChangeLevel(NormalValue);
        /// <summary> Important. </summary>
        public static PropertyChangeLevel Important { get; } = new PropertyChangeLevel(ImportantValue);
        /// <summary> Determines if two <see cref="PropertyChangeLevel"/> values are the same. </summary>
        public static bool operator ==(PropertyChangeLevel left, PropertyChangeLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PropertyChangeLevel"/> values are not the same. </summary>
        public static bool operator !=(PropertyChangeLevel left, PropertyChangeLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PropertyChangeLevel"/>. </summary>
        public static implicit operator PropertyChangeLevel(string value) => new PropertyChangeLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PropertyChangeLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PropertyChangeLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
